/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.analytics.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="\u0421\u0447\u0435\u0442\u0430 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430")
@Validated
public class ShopAccount {
    @JsonProperty(value="currency")
    private String currency = null;
    @JsonProperty(value="guaranteeID")
    private Long guaranteeID = null;
    @JsonProperty(value="settlementID")
    private Long settlementID = null;

    public ShopAccount currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0412\u0430\u043b\u044e\u0442\u0430, \u0441\u0438\u043c\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
    @NotNull
    @Pattern(regexp="^[A-Z]{3}$")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public ShopAccount guaranteeID(Long guaranteeID) {
        this.guaranteeID = guaranteeID;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    public Long getGuaranteeID() {
        return this.guaranteeID;
    }

    public void setGuaranteeID(Long guaranteeID) {
        this.guaranteeID = guaranteeID;
    }

    public ShopAccount settlementID(Long settlementID) {
        this.settlementID = settlementID;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    public Long getSettlementID() {
        return this.settlementID;
    }

    public void setSettlementID(Long settlementID) {
        this.settlementID = settlementID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShopAccount shopAccount = (ShopAccount)o;
        return Objects.equals(this.currency, shopAccount.currency) && Objects.equals(this.guaranteeID, shopAccount.guaranteeID) && Objects.equals(this.settlementID, shopAccount.settlementID);
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.guaranteeID, this.settlementID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShopAccount {\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    guaranteeID: ").append(this.toIndentedString(this.guaranteeID)).append("\n");
        sb.append("    settlementID: ").append(this.toIndentedString(this.settlementID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

