/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.analytics.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.vality.swag.analytics.model.PayoutToolDetails;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@Validated
public class Payout {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="shopID")
    private String shopID = null;
    @JsonProperty(value="createdAt")
    private OffsetDateTime createdAt = null;
    @JsonProperty(value="cancellationDetails")
    private String cancellationDetails = null;
    @JsonProperty(value="amount")
    private Long amount = null;
    @JsonProperty(value="fee")
    private Long fee = null;
    @JsonProperty(value="currency")
    private String currency = null;
    @JsonProperty(value="payoutToolDetails")
    private PayoutToolDetails payoutToolDetails = null;
    @JsonProperty(value="status")
    private String status = null;
    @JsonProperty(value="metadata")
    private Object metadata = null;

    public Payout id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0432\u044b\u043f\u043b\u0430\u0442\u044b")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Payout shopID(String shopID) {
        this.shopID = shopID;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430")
    @NotNull
    public String getShopID() {
        return this.shopID;
    }

    public void setShopID(String shopID) {
        this.shopID = shopID;
    }

    public Payout createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f")
    @NotNull
    @Valid
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Payout cancellationDetails(String cancellationDetails) {
        this.cancellationDetails = cancellationDetails;
        return this;
    }

    @ApiModelProperty(value="\u0414\u0435\u0442\u0430\u043b\u0438 \u043e\u0442\u043c\u0435\u043d\u044b \u0432\u044b\u043f\u043b\u0430\u0442\u044b")
    @Size(max=1000)
    public String getCancellationDetails() {
        return this.cancellationDetails;
    }

    public void setCancellationDetails(String cancellationDetails) {
        this.cancellationDetails = cancellationDetails;
    }

    public Payout amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0421\u0443\u043c\u043c\u0430 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0432 \u043c\u0438\u043d\u043e\u0440\u043d\u044b\u0445 \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0435\u0434\u0438\u043d\u0438\u0446\u0430\u0445, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 \u0432 \u043a\u043e\u043f\u0435\u0439\u043a\u0430\u0445 \u0432 \u0441\u043b\u0443\u0447\u0430\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0445 \u0440\u0443\u0431\u043b\u0435\u0439 \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0432\u0430\u043b\u044e\u0442\u044b. ")
    @NotNull
    @Min(value=1L)
    public Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Payout fee(Long fee) {
        this.fee = fee;
        return this;
    }

    @ApiModelProperty(value="\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u044b, \u0432 \u043c\u0438\u043d\u043e\u0440\u043d\u044b\u0445 \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0435\u0434\u0438\u043d\u0438\u0446\u0430\u0445")
    @Min(value=0L)
    public Long getFee() {
        return this.fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Payout currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0412\u0430\u043b\u044e\u0442\u0430, \u0441\u0438\u043c\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
    @NotNull
    @Pattern(regexp="^[A-Z]{3}$")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Payout payoutToolDetails(PayoutToolDetails payoutToolDetails) {
        this.payoutToolDetails = payoutToolDetails;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public PayoutToolDetails getPayoutToolDetails() {
        return this.payoutToolDetails;
    }

    public void setPayoutToolDetails(PayoutToolDetails payoutToolDetails) {
        this.payoutToolDetails = payoutToolDetails;
    }

    public Payout status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u0432\u044b\u043f\u043b\u0430\u0442\u044b")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Payout metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="{\"payoutDesc\":\"Custom payout\"}", value="\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u044b\u0439, \u0441\u043f\u0435\u0446\u0438\u0444\u0438\u0447\u043d\u044b\u0439 \u0434\u043b\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u0430 API \u0438 \u043d\u0435\u043f\u0440\u043e\u0437\u0440\u0430\u0447\u043d\u044b\u0439 \u0434\u043b\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043d\u0430\u0431\u043e\u0440 \u0434\u0430\u043d\u043d\u044b\u0445, \u0430\u0441\u0441\u043e\u0446\u0438\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u0432\u044b\u043f\u043b\u0430\u0442\u043e\u0439 ")
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payout payout = (Payout)o;
        return Objects.equals(this.id, payout.id) && Objects.equals(this.shopID, payout.shopID) && Objects.equals(this.createdAt, payout.createdAt) && Objects.equals(this.cancellationDetails, payout.cancellationDetails) && Objects.equals(this.amount, payout.amount) && Objects.equals(this.fee, payout.fee) && Objects.equals(this.currency, payout.currency) && Objects.equals(this.payoutToolDetails, payout.payoutToolDetails) && Objects.equals(this.status, payout.status) && Objects.equals(this.metadata, payout.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.shopID, this.createdAt, this.cancellationDetails, this.amount, this.fee, this.currency, this.payoutToolDetails, this.status, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Payout {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    shopID: ").append(this.toIndentedString(this.shopID)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    cancellationDetails: ").append(this.toIndentedString(this.cancellationDetails)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    payoutToolDetails: ").append(this.toIndentedString(this.payoutToolDetails)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

