/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.analytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.InvoiceCart;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@Validated
public class Invoice {
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="reason")
    private String reason = null;
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="externalID")
    private String externalID = null;
    @JsonProperty(value="shopID")
    private String shopID = null;
    @JsonProperty(value="createdAt")
    private OffsetDateTime createdAt = null;
    @JsonProperty(value="dueDate")
    private OffsetDateTime dueDate = null;
    @JsonProperty(value="amount")
    private Long amount = null;
    @JsonProperty(value="currency")
    private String currency = null;
    @JsonProperty(value="product")
    private String product = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="invoiceTemplateID")
    private String invoiceTemplateID = null;
    @JsonProperty(value="cart")
    private InvoiceCart cart = null;
    @JsonProperty(value="metadata")
    private Object metadata = null;

    public Invoice status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0421\u0442\u0430\u0442\u0443\u0441 \u0438\u043d\u0432\u043e\u0439\u0441\u0430")
    @NotNull
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Invoice reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="\u041f\u0440\u0438\u0447\u0438\u043d\u0430 \u043e\u0442\u043c\u0435\u043d\u044b \u0438\u043b\u0438 \u043f\u043e\u0433\u0430\u0448\u0435\u043d\u0438\u044f \u0438\u043d\u0432\u043e\u0439\u0441\u0430")
    @Size(max=1000)
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Invoice id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0438\u043d\u0432\u043e\u0439\u0441\u0430")
    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Invoice externalID(String externalID) {
        this.externalID = externalID;
        return this;
    }

    @ApiModelProperty(value="\u0412\u043d\u0435\u0448\u043d\u0438\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440")
    public String getExternalID() {
        return this.externalID;
    }

    public void setExternalID(String externalID) {
        this.externalID = externalID;
    }

    public Invoice shopID(String shopID) {
        this.shopID = shopID;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430")
    @NotNull
    public String getShopID() {
        return this.shopID;
    }

    public void setShopID(String shopID) {
        this.shopID = shopID;
    }

    public Invoice createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f")
    @NotNull
    @Valid
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Invoice dueDate(OffsetDateTime dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f")
    @NotNull
    @Valid
    public OffsetDateTime getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(OffsetDateTime dueDate) {
        this.dueDate = dueDate;
    }

    public Invoice amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u044b\u0445 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433, \u0432 \u043c\u0438\u043d\u043e\u0440\u043d\u044b\u0445 \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0435\u0434\u0438\u043d\u0438\u0446\u0430\u0445, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 \u0432 \u043a\u043e\u043f\u0435\u0439\u043a\u0430\u0445 \u0432 \u0441\u043b\u0443\u0447\u0430\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0445 \u0440\u0443\u0431\u043b\u0435\u0439 \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0432\u0430\u043b\u044e\u0442\u044b. ")
    @NotNull
    @Min(value=1L)
    public Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Invoice currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0412\u0430\u043b\u044e\u0442\u0430, \u0441\u0438\u043c\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
    @NotNull
    @Pattern(regexp="^[A-Z]{3}$")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Invoice product(String product) {
        this.product = product;
        return this;
    }

    @ApiModelProperty(required=true, value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u044b\u0445 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433")
    @NotNull
    @Size(max=100)
    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public Invoice description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u044b\u0445 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0438\u043b\u0438 \u0443\u0441\u043b\u0443\u0433")
    @Size(max=1000)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Invoice invoiceTemplateID(String invoiceTemplateID) {
        this.invoiceTemplateID = invoiceTemplateID;
        return this;
    }

    @ApiModelProperty(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 (\u0434\u043b\u044f \u0438\u043d\u0432\u043e\u0439\u0441\u043e\u0432, \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e \u0448\u0430\u0431\u043b\u043e\u043d\u0443).")
    public String getInvoiceTemplateID() {
        return this.invoiceTemplateID;
    }

    public void setInvoiceTemplateID(String invoiceTemplateID) {
        this.invoiceTemplateID = invoiceTemplateID;
    }

    public Invoice cart(InvoiceCart cart) {
        this.cart = cart;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public InvoiceCart getCart() {
        return this.cart;
    }

    public void setCart(InvoiceCart cart) {
        this.cart = cart;
    }

    public Invoice metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0421\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0441 \u0438\u043d\u0432\u043e\u0439\u0441\u043e\u043c \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435")
    @NotNull
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invoice invoice = (Invoice)o;
        return Objects.equals((Object)this.status, (Object)invoice.status) && Objects.equals(this.reason, invoice.reason) && Objects.equals(this.id, invoice.id) && Objects.equals(this.externalID, invoice.externalID) && Objects.equals(this.shopID, invoice.shopID) && Objects.equals(this.createdAt, invoice.createdAt) && Objects.equals(this.dueDate, invoice.dueDate) && Objects.equals(this.amount, invoice.amount) && Objects.equals(this.currency, invoice.currency) && Objects.equals(this.product, invoice.product) && Objects.equals(this.description, invoice.description) && Objects.equals(this.invoiceTemplateID, invoice.invoiceTemplateID) && Objects.equals(this.cart, invoice.cart) && Objects.equals(this.metadata, invoice.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.reason, this.id, this.externalID, this.shopID, this.createdAt, this.dueDate, this.amount, this.currency, this.product, this.description, this.invoiceTemplateID, this.cart, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Invoice {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    externalID: ").append(this.toIndentedString(this.externalID)).append("\n");
        sb.append("    shopID: ").append(this.toIndentedString(this.shopID)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    invoiceTemplateID: ").append(this.toIndentedString(this.invoiceTemplateID)).append("\n");
        sb.append("    cart: ").append(this.toIndentedString(this.cart)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        UNPAID("unpaid"),
        CANCELLED("cancelled"),
        PAID("paid"),
        FULFILLED("fulfilled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

