/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.analytics.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.ChargebackReason;
import dev.vality.swag.analytics.model.Content;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.springframework.validation.annotation.Validated;

@Validated
public class Chargeback {
    @JsonProperty(value="invoiceId")
    private String invoiceId = null;
    @JsonProperty(value="paymentId")
    private String paymentId = null;
    @JsonProperty(value="chargebackId")
    private String chargebackId = null;
    @JsonProperty(value="externalId")
    private String externalId = null;
    @JsonProperty(value="shopID")
    private String shopID = null;
    @JsonProperty(value="createdAt")
    private OffsetDateTime createdAt = null;
    @JsonProperty(value="levyAmount")
    private Long levyAmount = null;
    @JsonProperty(value="levyCurrency")
    private String levyCurrency = null;
    @JsonProperty(value="bodyAmount")
    private Long bodyAmount = null;
    @JsonProperty(value="bodyCurrency")
    private String bodyCurrency = null;
    @JsonProperty(value="fee")
    private Long fee = null;
    @JsonProperty(value="providerFee")
    private Long providerFee = null;
    @JsonProperty(value="externalFee")
    private Long externalFee = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="stage")
    private StageEnum stage = null;
    @JsonProperty(value="chargebackReason")
    private ChargebackReason chargebackReason = null;
    @JsonProperty(value="content")
    private Content content = null;

    public Chargeback invoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0438\u043d\u0432\u043e\u0439\u0441\u0430")
    @NotNull
    public String getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    public Chargeback paymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u0430")
    @NotNull
    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public Chargeback chargebackId(String chargebackId) {
        this.chargebackId = chargebackId;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0447\u0430\u0440\u0434\u0436\u0431\u044d\u043a\u0430")
    @NotNull
    public String getChargebackId() {
        return this.chargebackId;
    }

    public void setChargebackId(String chargebackId) {
        this.chargebackId = chargebackId;
    }

    public Chargeback externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @ApiModelProperty(value="\u0412\u043d\u0435\u0448\u043d\u0438\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Chargeback shopID(String shopID) {
        this.shopID = shopID;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430")
    @NotNull
    public String getShopID() {
        return this.shopID;
    }

    public void setShopID(String shopID) {
        this.shopID = shopID;
    }

    public Chargeback createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f")
    @NotNull
    @Valid
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Chargeback levyAmount(Long levyAmount) {
        this.levyAmount = levyAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0421\u0443\u043c\u043c\u0430 \u0441\u043f\u0438\u0441\u044b\u0432\u0430\u0435\u043c\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0443 \u0447\u0430\u0440\u0434\u0436\u0431\u0435\u043a\u0430")
    @NotNull
    @Min(value=1L)
    public Long getLevyAmount() {
        return this.levyAmount;
    }

    public void setLevyAmount(Long levyAmount) {
        this.levyAmount = levyAmount;
    }

    public Chargeback levyCurrency(String levyCurrency) {
        this.levyCurrency = levyCurrency;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0412\u0430\u043b\u044e\u0442\u0430, \u0441\u0438\u043c\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
    @NotNull
    @Pattern(regexp="^[A-Z]{3}$")
    public String getLevyCurrency() {
        return this.levyCurrency;
    }

    public void setLevyCurrency(String levyCurrency) {
        this.levyCurrency = levyCurrency;
    }

    public Chargeback bodyAmount(Long bodyAmount) {
        this.bodyAmount = bodyAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0421\u0443\u043c\u043c\u0430 \u0447\u0430\u0440\u0434\u0436\u0431\u044d\u043a\u0430")
    @NotNull
    @Min(value=1L)
    public Long getBodyAmount() {
        return this.bodyAmount;
    }

    public void setBodyAmount(Long bodyAmount) {
        this.bodyAmount = bodyAmount;
    }

    public Chargeback bodyCurrency(String bodyCurrency) {
        this.bodyCurrency = bodyCurrency;
        return this;
    }

    @ApiModelProperty(required=true, value="\u0412\u0430\u043b\u044e\u0442\u0430, \u0441\u0438\u043c\u0432\u043e\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
    @NotNull
    @Pattern(regexp="^[A-Z]{3}$")
    public String getBodyCurrency() {
        return this.bodyCurrency;
    }

    public void setBodyCurrency(String bodyCurrency) {
        this.bodyCurrency = bodyCurrency;
    }

    public Chargeback fee(Long fee) {
        this.fee = fee;
        return this;
    }

    @ApiModelProperty(value="\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u044b, \u0432 \u043c\u0438\u043d\u043e\u0440\u043d\u044b\u0445 \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0435\u0434\u0438\u043d\u0438\u0446\u0430\u0445")
    @Min(value=0L)
    public Long getFee() {
        return this.fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Chargeback providerFee(Long providerFee) {
        this.providerFee = providerFee;
        return this;
    }

    @ApiModelProperty(value="\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430, \u0432 \u043c\u0438\u043d\u043e\u0440\u043d\u044b\u0445 \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0435\u0434\u0438\u043d\u0438\u0446\u0430\u0445")
    @Min(value=0L)
    public Long getProviderFee() {
        return this.providerFee;
    }

    public void setProviderFee(Long providerFee) {
        this.providerFee = providerFee;
    }

    public Chargeback externalFee(Long externalFee) {
        this.externalFee = externalFee;
        return this;
    }

    @ApiModelProperty(value="\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u0432\u043d\u0435\u0448\u043d\u0435\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0441\u0438\u0441\u0442\u0435\u043c\u044b, \u0432 \u043c\u0438\u043d\u043e\u0440\u043d\u044b\u0445 \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0435\u0434\u0438\u043d\u0438\u0446\u0430\u0445")
    @Min(value=0L)
    public Long getExternalFee() {
        return this.externalFee;
    }

    public void setExternalFee(Long externalFee) {
        this.externalFee = externalFee;
    }

    public Chargeback status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u0447\u0430\u0440\u0434\u0436\u0431\u044d\u043a\u0430")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Chargeback stage(StageEnum stage) {
        this.stage = stage;
        return this;
    }

    @ApiModelProperty(value="\u042d\u0442\u0430\u043f \u043f\u0440\u043e\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0447\u0430\u0440\u0434\u0436\u0431\u044d\u043a\u0430")
    public StageEnum getStage() {
        return this.stage;
    }

    public void setStage(StageEnum stage) {
        this.stage = stage;
    }

    public Chargeback chargebackReason(ChargebackReason chargebackReason) {
        this.chargebackReason = chargebackReason;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public ChargebackReason getChargebackReason() {
        return this.chargebackReason;
    }

    public void setChargebackReason(ChargebackReason chargebackReason) {
        this.chargebackReason = chargebackReason;
    }

    public Chargeback content(Content content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chargeback chargeback = (Chargeback)o;
        return Objects.equals(this.invoiceId, chargeback.invoiceId) && Objects.equals(this.paymentId, chargeback.paymentId) && Objects.equals(this.chargebackId, chargeback.chargebackId) && Objects.equals(this.externalId, chargeback.externalId) && Objects.equals(this.shopID, chargeback.shopID) && Objects.equals(this.createdAt, chargeback.createdAt) && Objects.equals(this.levyAmount, chargeback.levyAmount) && Objects.equals(this.levyCurrency, chargeback.levyCurrency) && Objects.equals(this.bodyAmount, chargeback.bodyAmount) && Objects.equals(this.bodyCurrency, chargeback.bodyCurrency) && Objects.equals(this.fee, chargeback.fee) && Objects.equals(this.providerFee, chargeback.providerFee) && Objects.equals(this.externalFee, chargeback.externalFee) && Objects.equals((Object)this.status, (Object)chargeback.status) && Objects.equals((Object)this.stage, (Object)chargeback.stage) && Objects.equals(this.chargebackReason, chargeback.chargebackReason) && Objects.equals(this.content, chargeback.content);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.invoiceId, this.paymentId, this.chargebackId, this.externalId, this.shopID, this.createdAt, this.levyAmount, this.levyCurrency, this.bodyAmount, this.bodyCurrency, this.fee, this.providerFee, this.externalFee, this.status, this.stage, this.chargebackReason, this.content});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Chargeback {\n");
        sb.append("    invoiceId: ").append(this.toIndentedString(this.invoiceId)).append("\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    chargebackId: ").append(this.toIndentedString(this.chargebackId)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    shopID: ").append(this.toIndentedString(this.shopID)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    levyAmount: ").append(this.toIndentedString(this.levyAmount)).append("\n");
        sb.append("    levyCurrency: ").append(this.toIndentedString(this.levyCurrency)).append("\n");
        sb.append("    bodyAmount: ").append(this.toIndentedString(this.bodyAmount)).append("\n");
        sb.append("    bodyCurrency: ").append(this.toIndentedString(this.bodyCurrency)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    providerFee: ").append(this.toIndentedString(this.providerFee)).append("\n");
        sb.append("    externalFee: ").append(this.toIndentedString(this.externalFee)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    stage: ").append(this.toIndentedString((Object)this.stage)).append("\n");
        sb.append("    chargebackReason: ").append(this.toIndentedString(this.chargebackReason)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        PENDING("pending"),
        ACCEPTED("accepted"),
        REJECTED("rejected"),
        CANCELLED("cancelled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum StageEnum {
        CHARGEBACK("chargeback"),
        PRE_ARBITRATION("pre_arbitration"),
        ARBITRATION("arbitration");

        private String value;

        private StageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StageEnum fromValue(String text) {
            for (StageEnum b : StageEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

