/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.swag.analytics.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.vality.swag.analytics.model.DefaultLogicError;
import dev.vality.swag.analytics.model.GeneralError;
import dev.vality.swag.analytics.model.InlineResponse200;
import dev.vality.swag.analytics.model.InlineResponse2001;
import dev.vality.swag.analytics.model.InlineResponse2002;
import dev.vality.swag.analytics.model.InlineResponse2003;
import dev.vality.swag.analytics.model.InlineResponse2004;
import dev.vality.swag.analytics.model.InlineResponse2005;
import dev.vality.swag.analytics.model.InlineResponse2006;
import dev.vality.swag.analytics.model.InlineResponse2007;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="analytics", description="the analytics API")
public interface AnalyticsApi {
    public static final Logger log = LoggerFactory.getLogger(AnalyticsApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value="", nickname="getAveragePayment", notes="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u0440\u0435\u0434\u043d\u0435\u0433\u043e \u0440\u0430\u0437\u043c\u0435\u0440\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0441 \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u043e\u0439 \u043f\u043e \u0432\u0430\u043b\u044e\u0442\u0430\u043c", response=InlineResponse2001.class, authorizations={@Authorization(value="bearer")}, tags={"Analytics"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u0421\u0440\u0435\u0434\u043d\u0438\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0441 \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u043e\u0439 \u043f\u043e \u0432\u0430\u043b\u044e\u0442\u0430\u043c", response=InlineResponse2001.class), @ApiResponse(code=400, message="\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", response=DefaultLogicError.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(value={"/analytics/payments/average"}, produces={"application/json; charset=utf-8"}, consumes={"application/json; charset=utf-8"}, method={RequestMethod.GET})
    default public ResponseEntity<InlineResponse2001> getAveragePayment(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) String partyID, @NotNull @ApiParam(value="\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="fromTime", required=true) OffsetDateTime fromTime, @NotNull @ApiParam(value="\u041a\u043e\u043d\u0435\u0446 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="toTime", required=true) OffsetDateTime toTime, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432") @Valid @RequestParam(value="shopIDs", required=false) List<String> shopIDs, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u044b\u0435 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441") @Valid @RequestParam(value="excludeShopIDs", required=false) List<String> excludeShopIDs, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((InlineResponse2001)this.getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ]}", InlineResponse2001.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="", nickname="getCurrentBalances", notes="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u043f\u043e \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0443", response=InlineResponse2001.class, authorizations={@Authorization(value="bearer")}, tags={"Analytics"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u0421\u043f\u0438\u0441\u043e\u043a \u043e\u0431\u043e\u0440\u043e\u0442\u043e\u0432 \u0441 \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u043e\u0439 \u043f\u043e \u0432\u0430\u043b\u044e\u0442\u0430\u043c", response=InlineResponse2001.class), @ApiResponse(code=400, message="\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", response=DefaultLogicError.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(value={"/analytics/balances/current"}, produces={"application/json; charset=utf-8"}, consumes={"application/json; charset=utf-8"}, method={RequestMethod.GET})
    default public ResponseEntity<InlineResponse2001> getCurrentBalances(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) String partyID, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432") @Valid @RequestParam(value="shopIDs", required=false) List<String> shopIDs, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u044b\u0435 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441") @Valid @RequestParam(value="excludeShopIDs", required=false) List<String> excludeShopIDs, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((InlineResponse2001)this.getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ]}", InlineResponse2001.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="", nickname="getCurrentBalancesGroupByShop", notes="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0441 \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u043e\u0439 \u043f\u043e \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430\u043c", response=InlineResponse200.class, authorizations={@Authorization(value="bearer")}, tags={"Analytics"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u0421\u043f\u0438\u0441\u043e\u043a \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u0432 \u0441 \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u043e\u0439 \u043f\u043e \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430\u043c", response=InlineResponse200.class), @ApiResponse(code=400, message="\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", response=DefaultLogicError.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(value={"/analytics/balances/current-shop-balances"}, produces={"application/json; charset=utf-8"}, consumes={"application/json; charset=utf-8"}, method={RequestMethod.GET})
    default public ResponseEntity<InlineResponse200> getCurrentBalancesGroupByShop(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) String partyID, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432") @Valid @RequestParam(value="shopIDs", required=false) List<String> shopIDs, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u044b\u0435 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441") @Valid @RequestParam(value="excludeShopIDs", required=false) List<String> excludeShopIDs) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((InlineResponse200)this.getObjectMapper().get().readValue("{  \"result\" : [ {    \"groupBySHopResults\" : [ {      \"amountResults\" : [ \"\", \"\" ],      \"id\" : \"id\"    }, {      \"amountResults\" : [ \"\", \"\" ],      \"id\" : \"id\"    } ]  }, {    \"groupBySHopResults\" : [ {      \"amountResults\" : [ \"\", \"\" ],      \"id\" : \"id\"    }, {      \"amountResults\" : [ \"\", \"\" ],      \"id\" : \"id\"    } ]  } ]}", InlineResponse200.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="", nickname="getPaymentsAmount", notes="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u043e\u0431\u043e\u0440\u043e\u0442\u043e\u0432 \u0441 \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u043e\u0439 \u043f\u043e \u0432\u0430\u043b\u044e\u0442\u0430\u043c", response=InlineResponse2001.class, authorizations={@Authorization(value="bearer")}, tags={"Analytics"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u0421\u043f\u0438\u0441\u043e\u043a \u043e\u0431\u043e\u0440\u043e\u0442\u043e\u0432 \u0441 \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u043e\u0439 \u043f\u043e \u0432\u0430\u043b\u044e\u0442\u0430\u043c", response=InlineResponse2001.class), @ApiResponse(code=400, message="\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", response=DefaultLogicError.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(value={"/analytics/payments/amount"}, produces={"application/json; charset=utf-8"}, consumes={"application/json; charset=utf-8"}, method={RequestMethod.GET})
    default public ResponseEntity<InlineResponse2001> getPaymentsAmount(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) String partyID, @NotNull @ApiParam(value="\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="fromTime", required=true) OffsetDateTime fromTime, @NotNull @ApiParam(value="\u041a\u043e\u043d\u0435\u0446 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="toTime", required=true) OffsetDateTime toTime, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432") @Valid @RequestParam(value="shopIDs", required=false) List<String> shopIDs, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u044b\u0435 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441") @Valid @RequestParam(value="excludeShopIDs", required=false) List<String> excludeShopIDs, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((InlineResponse2001)this.getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ]}", InlineResponse2001.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="", nickname="getPaymentsCount", notes="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0441 \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u043e\u0439 \u043f\u043e \u0432\u0430\u043b\u044e\u0442\u0430\u043c", response=InlineResponse2003.class, authorizations={@Authorization(value="bearer")}, tags={"Analytics"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u0421\u0440\u0435\u0434\u043d\u0435\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0441 \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u043e\u0439 \u043f\u043e \u0432\u0430\u043b\u044e\u0442\u0430\u043c", response=InlineResponse2003.class), @ApiResponse(code=400, message="\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", response=DefaultLogicError.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(value={"/analytics/payments/count"}, produces={"application/json; charset=utf-8"}, consumes={"application/json; charset=utf-8"}, method={RequestMethod.GET})
    default public ResponseEntity<InlineResponse2003> getPaymentsCount(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) String partyID, @NotNull @ApiParam(value="\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="fromTime", required=true) OffsetDateTime fromTime, @NotNull @ApiParam(value="\u041a\u043e\u043d\u0435\u0446 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="toTime", required=true) OffsetDateTime toTime, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432") @Valid @RequestParam(value="shopIDs", required=false) List<String> shopIDs, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u044b\u0435 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441") @Valid @RequestParam(value="excludeShopIDs", required=false) List<String> excludeShopIDs, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((InlineResponse2003)this.getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ]}", InlineResponse2003.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="", nickname="getPaymentsErrorDistribution", notes="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043e\u0448\u0438\u0431\u043e\u043a", response=InlineResponse2004.class, authorizations={@Authorization(value="bearer")}, tags={"Analytics"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u043e\u0448\u0438\u0431\u043e\u043a", response=InlineResponse2004.class), @ApiResponse(code=400, message="\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", response=DefaultLogicError.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(value={"/analytics/payments/errors"}, produces={"application/json; charset=utf-8"}, consumes={"application/json; charset=utf-8"}, method={RequestMethod.GET})
    default public ResponseEntity<InlineResponse2004> getPaymentsErrorDistribution(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) String partyID, @NotNull @ApiParam(value="\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="fromTime", required=true) OffsetDateTime fromTime, @NotNull @ApiParam(value="\u041a\u043e\u043d\u0435\u0446 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="toTime", required=true) OffsetDateTime toTime, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432") @Valid @RequestParam(value="shopIDs", required=false) List<String> shopIDs, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u044b\u0435 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441") @Valid @RequestParam(value="excludeShopIDs", required=false) List<String> excludeShopIDs, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((InlineResponse2004)this.getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ]}", InlineResponse2004.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="", nickname="getPaymentsSplitAmount", notes="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u043e\u0431\u043e\u0440\u043e\u0442\u043e\u0432 \u0441 \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u043e\u0439 \u043f\u043e \u0432\u0430\u043b\u044e\u0442\u0430\u043c \u0438 \u0440\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u043f\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u043c \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0430\u043c", response=InlineResponse2005.class, authorizations={@Authorization(value="bearer")}, tags={"Analytics"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u0421\u043f\u0438\u0441\u043e\u043a \u043e\u0431\u043e\u0440\u043e\u0442\u043e\u0432 \u0441 \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u043e\u0439 \u043f\u043e \u0432\u0430\u043b\u044e\u0442\u0430\u043c \u0438 \u0440\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u043f\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u043c \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0430\u043c", response=InlineResponse2005.class), @ApiResponse(code=400, message="\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", response=DefaultLogicError.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(value={"/analytics/payments/split-amount"}, produces={"application/json; charset=utf-8"}, consumes={"application/json; charset=utf-8"}, method={RequestMethod.GET})
    default public ResponseEntity<InlineResponse2005> getPaymentsSplitAmount(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) String partyID, @NotNull @ApiParam(value="\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="fromTime", required=true) OffsetDateTime fromTime, @NotNull @ApiParam(value="\u041a\u043e\u043d\u0435\u0446 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="toTime", required=true) OffsetDateTime toTime, @NotNull @ApiParam(value="\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u0440\u0430\u0437\u0431\u0438\u0435\u043d\u0438\u044f", required=true, allowableValues="minute, hour, day, week, month, year") @Valid @RequestParam(value="splitUnit", required=true) String splitUnit, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432") @Valid @RequestParam(value="shopIDs", required=false) List<String> shopIDs, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u044b\u0435 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441") @Valid @RequestParam(value="excludeShopIDs", required=false) List<String> excludeShopIDs, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((InlineResponse2005)this.getObjectMapper().get().readValue("{  \"result\" : [ {    \"splitUnit\" : \"minute\",    \"currency\" : \"currency\",    \"offsetAmounts\" : [ {      \"amount\" : 1,      \"offset\" : 0    }, {      \"amount\" : 1,      \"offset\" : 0    } ]  }, {    \"splitUnit\" : \"minute\",    \"currency\" : \"currency\",    \"offsetAmounts\" : [ {      \"amount\" : 1,      \"offset\" : 0    }, {      \"amount\" : 1,      \"offset\" : 0    } ]  } ]}", InlineResponse2005.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="", nickname="getPaymentsSplitCount", notes="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0441 \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u043e\u0439 \u043f\u043e \u0432\u0430\u043b\u044e\u0442\u0430\u043c \u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430\u043c, \u0440\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u043c \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0430\u043c", response=InlineResponse2006.class, authorizations={@Authorization(value="bearer")}, tags={"Analytics"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0441 \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u043e\u0439 \u043f\u043e \u0432\u0430\u043b\u044e\u0442\u0430\u043c \u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430\u043c, \u0440\u0430\u0437\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0435 \u043f\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u043c \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0430\u043c", response=InlineResponse2006.class), @ApiResponse(code=400, message="\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", response=DefaultLogicError.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(value={"/analytics/payments/split-count"}, produces={"application/json; charset=utf-8"}, consumes={"application/json; charset=utf-8"}, method={RequestMethod.GET})
    default public ResponseEntity<InlineResponse2006> getPaymentsSplitCount(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) String partyID, @NotNull @ApiParam(value="\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="fromTime", required=true) OffsetDateTime fromTime, @NotNull @ApiParam(value="\u041a\u043e\u043d\u0435\u0446 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="toTime", required=true) OffsetDateTime toTime, @NotNull @ApiParam(value="\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u0440\u0430\u0437\u0431\u0438\u0435\u043d\u0438\u044f", required=true, allowableValues="minute, hour, day, week, month, year") @Valid @RequestParam(value="splitUnit", required=true) String splitUnit, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432") @Valid @RequestParam(value="shopIDs", required=false) List<String> shopIDs, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u044b\u0435 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441") @Valid @RequestParam(value="excludeShopIDs", required=false) List<String> excludeShopIDs, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((InlineResponse2006)this.getObjectMapper().get().readValue("{  \"result\" : [ {    \"splitUnit\" : \"minute\",    \"statusOffsetCounts\" : [ {      \"status\" : \"pending\",      \"offsetCount\" : [ \"\", \"\" ]    }, {      \"status\" : \"pending\",      \"offsetCount\" : [ \"\", \"\" ]    } ],    \"currency\" : \"currency\"  }, {    \"splitUnit\" : \"minute\",    \"statusOffsetCounts\" : [ {      \"status\" : \"pending\",      \"offsetCount\" : [ \"\", \"\" ]    }, {      \"status\" : \"pending\",      \"offsetCount\" : [ \"\", \"\" ]    } ],    \"currency\" : \"currency\"  } ]}", InlineResponse2006.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="", nickname="getPaymentsSubErrorDistribution", notes="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043e\u0448\u0438\u0431\u043e\u043a \u0441 \u043f\u043e\u0434\u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438", response=InlineResponse2007.class, authorizations={@Authorization(value="bearer")}, tags={"Analytics"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u043e\u0448\u0438\u0431\u043e\u043a \u0441 \u043f\u043e\u0434\u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438", response=InlineResponse2007.class), @ApiResponse(code=400, message="\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", response=DefaultLogicError.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(value={"/analytics/payments/sub-errors"}, produces={"application/json; charset=utf-8"}, consumes={"application/json; charset=utf-8"}, method={RequestMethod.GET})
    default public ResponseEntity<InlineResponse2007> getPaymentsSubErrorDistribution(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) String partyID, @NotNull @ApiParam(value="\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="fromTime", required=true) OffsetDateTime fromTime, @NotNull @ApiParam(value="\u041a\u043e\u043d\u0435\u0446 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="toTime", required=true) OffsetDateTime toTime, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432") @Valid @RequestParam(value="shopIDs", required=false) List<String> shopIDs, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u044b\u0435 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441") @Valid @RequestParam(value="excludeShopIDs", required=false) List<String> excludeShopIDs, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((InlineResponse2007)this.getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ]}", InlineResponse2007.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="", nickname="getPaymentsToolDistribution", notes="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0445 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u043e\u0432", response=InlineResponse2002.class, authorizations={@Authorization(value="bearer")}, tags={"Analytics"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0445 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u043e\u0432", response=InlineResponse2002.class), @ApiResponse(code=400, message="\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", response=DefaultLogicError.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(value={"/analytics/payments-tool"}, produces={"application/json; charset=utf-8"}, consumes={"application/json; charset=utf-8"}, method={RequestMethod.GET})
    default public ResponseEntity<InlineResponse2002> getPaymentsToolDistribution(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) String partyID, @NotNull @ApiParam(value="\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="fromTime", required=true) OffsetDateTime fromTime, @NotNull @ApiParam(value="\u041a\u043e\u043d\u0435\u0446 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="toTime", required=true) OffsetDateTime toTime, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432") @Valid @RequestParam(value="shopIDs", required=false) List<String> shopIDs, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u044b\u0435 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441") @Valid @RequestParam(value="excludeShopIDs", required=false) List<String> excludeShopIDs, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((InlineResponse2002)this.getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ]}", InlineResponse2002.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="", nickname="getRefundsAmount", notes="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u043e\u0432 \u0441 \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u043e\u0439 \u043f\u043e \u0432\u0430\u043b\u044e\u0442\u0430\u043c", response=InlineResponse2001.class, authorizations={@Authorization(value="bearer")}, tags={"Analytics"})
    @ApiResponses(value={@ApiResponse(code=200, message="\u0421\u043f\u0438\u0441\u043e\u043a \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u043e\u0432 \u0441 \u0433\u0440\u0443\u043f\u043f\u0438\u0440\u043e\u0432\u043a\u043e\u0439 \u043f\u043e \u0432\u0430\u043b\u044e\u0442\u0430\u043c", response=InlineResponse2001.class), @ApiResponse(code=400, message="\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", response=DefaultLogicError.class), @ApiResponse(code=401, message="\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438"), @ApiResponse(code=404, message="\u0417\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", response=GeneralError.class)})
    @RequestMapping(value={"/analytics/refunds/amount"}, produces={"application/json; charset=utf-8"}, consumes={"application/json; charset=utf-8"}, method={RequestMethod.GET})
    default public ResponseEntity<InlineResponse2001> getRefundsAmount(@ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID, @NotNull @Size(min=1, max=40) @ApiParam(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0443\u0447\u0430\u0441\u0442\u043d\u0438\u043a\u0430 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b", required=true) @Valid @RequestParam(value="partyID", required=true) String partyID, @NotNull @ApiParam(value="\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="fromTime", required=true) OffsetDateTime fromTime, @NotNull @ApiParam(value="\u041a\u043e\u043d\u0435\u0446 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u043e\u0442\u0440\u0435\u0437\u043a\u0430", required=true) @Valid @RequestParam(value="toTime", required=true) OffsetDateTime toTime, @ApiParam(value="\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430") @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432") @Valid @RequestParam(value="shopIDs", required=false) List<String> shopIDs, @ApiParam(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u044b \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u044b\u0435 \u0432 \u0437\u0430\u043f\u0440\u043e\u0441") @Valid @RequestParam(value="excludeShopIDs", required=false) List<String> excludeShopIDs, @ApiParam(value="\u0422\u0438\u043f \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430, \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0438\u043b\u0438 \u00ab\u0431\u043e\u0435\u0432\u043e\u0439\u00bb", allowableValues="live, test") @Valid @RequestParam(value="paymentInstitutionRealm", required=false) String paymentInstitutionRealm) {
        if (this.getObjectMapper().isPresent() && this.getAcceptHeader().isPresent()) {
            if (this.getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity((Object)((InlineResponse2001)this.getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ]}", InlineResponse2001.class)), HttpStatus.NOT_IMPLEMENTED);
                }
                catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", (Throwable)e);
                    return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

