package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag.analytics.model.SubError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Детализация описания ошибки 
 */
@ApiModel(description = "Детализация описания ошибки ")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class SubError   {
  @JsonProperty("code")
  private String code = null;

  @JsonProperty("subError")
  private SubError subError = null;

  public SubError code(String code) {
    this.code = code;
    return this;
  }

  /**
   * Детализация кода ошибки
   * @return code
  **/
  @ApiModelProperty(required = true, value = "Детализация кода ошибки")
  @NotNull


  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public SubError subError(SubError subError) {
    this.subError = subError;
    return this;
  }

  /**
   * Get subError
   * @return subError
  **/
  @ApiModelProperty(value = "")

  @Valid

  public SubError getSubError() {
    return subError;
  }

  public void setSubError(SubError subError) {
    this.subError = subError;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubError subError = (SubError) o;
    return Objects.equals(this.code, subError.code) &&
        Objects.equals(this.subError, subError.subError);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, subError);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubError {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    subError: ").append(toIndentedString(subError)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

