package dev.vality.swag.analytics.model;

import java.util.Objects;
import io.swagger.annotations.ApiModel;
import com.fasterxml.jackson.annotation.JsonValue;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

import com.fasterxml.jackson.annotation.JsonCreator;

/**
 * Единица времени сегмента разбиения
 */
public enum SplitUnit {
  
  MINUTE("minute"),
  
  HOUR("hour"),
  
  DAY("day"),
  
  WEEK("week"),
  
  MONTH("month"),
  
  YEAR("year");

  private String value;

  SplitUnit(String value) {
    this.value = value;
  }

  @Override
  @JsonValue
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static SplitUnit fromValue(String text) {
    for (SplitUnit b : SplitUnit.values()) {
      if (String.valueOf(b.value).equals(text)) {
        return b;
      }
    }
    return null;
  }
}

