package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.StatusOffsetCount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * SplitCountResult
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class SplitCountResult   {
  /**
   * Единица времени сегмента разбиения
   */
  public enum SplitUnitEnum {
    MINUTE("minute"),
    
    HOUR("hour"),
    
    DAY("day"),
    
    WEEK("week"),
    
    MONTH("month"),
    
    YEAR("year");

    private String value;

    SplitUnitEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SplitUnitEnum fromValue(String text) {
      for (SplitUnitEnum b : SplitUnitEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("splitUnit")
  private SplitUnitEnum splitUnit = null;

  @JsonProperty("currency")
  private String currency = null;

  @JsonProperty("statusOffsetCounts")
  @Valid
  private List<StatusOffsetCount> statusOffsetCounts = new ArrayList<>();

  public SplitCountResult splitUnit(SplitUnitEnum splitUnit) {
    this.splitUnit = splitUnit;
    return this;
  }

  /**
   * Единица времени сегмента разбиения
   * @return splitUnit
  **/
  @ApiModelProperty(required = true, value = "Единица времени сегмента разбиения")
  @NotNull


  public SplitUnitEnum getSplitUnit() {
    return splitUnit;
  }

  public void setSplitUnit(SplitUnitEnum splitUnit) {
    this.splitUnit = splitUnit;
  }

  public SplitCountResult currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).
   * @return currency
  **/
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
  @NotNull

@Pattern(regexp="^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public SplitCountResult statusOffsetCounts(List<StatusOffsetCount> statusOffsetCounts) {
    this.statusOffsetCounts = statusOffsetCounts;
    return this;
  }

  public SplitCountResult addStatusOffsetCountsItem(StatusOffsetCount statusOffsetCountsItem) {
    this.statusOffsetCounts.add(statusOffsetCountsItem);
    return this;
  }

  /**
   * Get statusOffsetCounts
   * @return statusOffsetCounts
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public List<StatusOffsetCount> getStatusOffsetCounts() {
    return statusOffsetCounts;
  }

  public void setStatusOffsetCounts(List<StatusOffsetCount> statusOffsetCounts) {
    this.statusOffsetCounts = statusOffsetCounts;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SplitCountResult splitCountResult = (SplitCountResult) o;
    return Objects.equals(this.splitUnit, splitCountResult.splitUnit) &&
        Objects.equals(this.currency, splitCountResult.currency) &&
        Objects.equals(this.statusOffsetCounts, splitCountResult.statusOffsetCounts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(splitUnit, currency, statusOffsetCounts);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SplitCountResult {\n");
    
    sb.append("    splitUnit: ").append(toIndentedString(splitUnit)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    statusOffsetCounts: ").append(toIndentedString(statusOffsetCounts)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

