package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.OffsetAmount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * SplitAmountResult
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class SplitAmountResult   {
  /**
   * Единица времени сегмента разбиения
   */
  public enum SplitUnitEnum {
    MINUTE("minute"),
    
    HOUR("hour"),
    
    DAY("day"),
    
    WEEK("week"),
    
    MONTH("month"),
    
    YEAR("year");

    private String value;

    SplitUnitEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SplitUnitEnum fromValue(String text) {
      for (SplitUnitEnum b : SplitUnitEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("splitUnit")
  private SplitUnitEnum splitUnit = null;

  @JsonProperty("currency")
  private String currency = null;

  @JsonProperty("offsetAmounts")
  @Valid
  private List<OffsetAmount> offsetAmounts = new ArrayList<>();

  public SplitAmountResult splitUnit(SplitUnitEnum splitUnit) {
    this.splitUnit = splitUnit;
    return this;
  }

  /**
   * Единица времени сегмента разбиения
   * @return splitUnit
  **/
  @ApiModelProperty(required = true, value = "Единица времени сегмента разбиения")
  @NotNull


  public SplitUnitEnum getSplitUnit() {
    return splitUnit;
  }

  public void setSplitUnit(SplitUnitEnum splitUnit) {
    this.splitUnit = splitUnit;
  }

  public SplitAmountResult currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).
   * @return currency
  **/
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
  @NotNull

@Pattern(regexp="^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public SplitAmountResult offsetAmounts(List<OffsetAmount> offsetAmounts) {
    this.offsetAmounts = offsetAmounts;
    return this;
  }

  public SplitAmountResult addOffsetAmountsItem(OffsetAmount offsetAmountsItem) {
    this.offsetAmounts.add(offsetAmountsItem);
    return this;
  }

  /**
   * Get offsetAmounts
   * @return offsetAmounts
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public List<OffsetAmount> getOffsetAmounts() {
    return offsetAmounts;
  }

  public void setOffsetAmounts(List<OffsetAmount> offsetAmounts) {
    this.offsetAmounts = offsetAmounts;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SplitAmountResult splitAmountResult = (SplitAmountResult) o;
    return Objects.equals(this.splitUnit, splitAmountResult.splitUnit) &&
        Objects.equals(this.currency, splitAmountResult.currency) &&
        Objects.equals(this.offsetAmounts, splitAmountResult.offsetAmounts);
  }

  @Override
  public int hashCode() {
    return Objects.hash(splitUnit, currency, offsetAmounts);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SplitAmountResult {\n");
    
    sb.append("    splitUnit: ").append(toIndentedString(splitUnit)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    offsetAmounts: ").append(toIndentedString(offsetAmounts)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

