package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Счета магазина
 */
@ApiModel(description = "Счета магазина")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class ShopAccount   {
  @JsonProperty("currency")
  private String currency = null;

  @JsonProperty("guaranteeID")
  private Long guaranteeID = null;

  @JsonProperty("settlementID")
  private Long settlementID = null;

  public ShopAccount currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).
   * @return currency
  **/
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
  @NotNull

@Pattern(regexp="^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public ShopAccount guaranteeID(Long guaranteeID) {
    this.guaranteeID = guaranteeID;
    return this;
  }

  /**
   * Get guaranteeID
   * @return guaranteeID
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public Long getGuaranteeID() {
    return guaranteeID;
  }

  public void setGuaranteeID(Long guaranteeID) {
    this.guaranteeID = guaranteeID;
  }

  public ShopAccount settlementID(Long settlementID) {
    this.settlementID = settlementID;
    return this;
  }

  /**
   * Get settlementID
   * @return settlementID
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public Long getSettlementID() {
    return settlementID;
  }

  public void setSettlementID(Long settlementID) {
    this.settlementID = settlementID;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ShopAccount shopAccount = (ShopAccount) o;
    return Objects.equals(this.currency, shopAccount.currency) &&
        Objects.equals(this.guaranteeID, shopAccount.guaranteeID) &&
        Objects.equals(this.settlementID, shopAccount.settlementID);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currency, guaranteeID, settlementID);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ShopAccount {\n");
    
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    guaranteeID: ").append(toIndentedString(guaranteeID)).append("\n");
    sb.append("    settlementID: ").append(toIndentedString(settlementID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

