package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag.analytics.model.ShopAccount;
import dev.vality.swag.analytics.model.ShopDetails;
import dev.vality.swag.analytics.model.ShopLocation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Данные магазина
 */
@ApiModel(description = "Данные магазина")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class Shop   {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("createdAt")
  private OffsetDateTime createdAt = null;

  @JsonProperty("isBlocked")
  private Boolean isBlocked = null;

  @JsonProperty("isSuspended")
  private Boolean isSuspended = null;

  @JsonProperty("categoryID")
  private Integer categoryID = null;

  @JsonProperty("location")
  private ShopLocation location = null;

  @JsonProperty("details")
  private ShopDetails details = null;

  @JsonProperty("contractID")
  private String contractID = null;

  @JsonProperty("payoutToolID")
  private String payoutToolID = null;

  @JsonProperty("scheduleID")
  private Integer scheduleID = null;

  @JsonProperty("account")
  private ShopAccount account = null;

  public Shop id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор магазина
   * @return id
  **/
  @ApiModelProperty(required = true, value = "Идентификатор магазина")
  @NotNull


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Shop createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Дата и время создания
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "Дата и время создания")
  @NotNull

  @Valid

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Shop isBlocked(Boolean isBlocked) {
    this.isBlocked = isBlocked;
    return this;
  }

  /**
   * Заблокирован ли магазин?
   * @return isBlocked
  **/
  @ApiModelProperty(required = true, value = "Заблокирован ли магазин?")
  @NotNull


  public Boolean isIsBlocked() {
    return isBlocked;
  }

  public void setIsBlocked(Boolean isBlocked) {
    this.isBlocked = isBlocked;
  }

  public Shop isSuspended(Boolean isSuspended) {
    this.isSuspended = isSuspended;
    return this;
  }

  /**
   * Приостановлены ли операции в рамках магазина?
   * @return isSuspended
  **/
  @ApiModelProperty(required = true, value = "Приостановлены ли операции в рамках магазина?")
  @NotNull


  public Boolean isIsSuspended() {
    return isSuspended;
  }

  public void setIsSuspended(Boolean isSuspended) {
    this.isSuspended = isSuspended;
  }

  public Shop categoryID(Integer categoryID) {
    this.categoryID = categoryID;
    return this;
  }

  /**
   * Идентификатор категории товаров и услуг, предлагаемых в этом магазине 
   * @return categoryID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор категории товаров и услуг, предлагаемых в этом магазине ")
  @NotNull


  public Integer getCategoryID() {
    return categoryID;
  }

  public void setCategoryID(Integer categoryID) {
    this.categoryID = categoryID;
  }

  public Shop location(ShopLocation location) {
    this.location = location;
    return this;
  }

  /**
   * Get location
   * @return location
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public ShopLocation getLocation() {
    return location;
  }

  public void setLocation(ShopLocation location) {
    this.location = location;
  }

  public Shop details(ShopDetails details) {
    this.details = details;
    return this;
  }

  /**
   * Get details
   * @return details
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public ShopDetails getDetails() {
    return details;
  }

  public void setDetails(ShopDetails details) {
    this.details = details;
  }

  public Shop contractID(String contractID) {
    this.contractID = contractID;
    return this;
  }

  /**
   * Идентификатор договора, на основании которого производится обслуживание магазина 
   * @return contractID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор договора, на основании которого производится обслуживание магазина ")
  @NotNull


  public String getContractID() {
    return contractID;
  }

  public void setContractID(String contractID) {
    this.contractID = contractID;
  }

  public Shop payoutToolID(String payoutToolID) {
    this.payoutToolID = payoutToolID;
    return this;
  }

  /**
   * Идентификатор средства вывода в рамках контракта, используемое в процессе вывода по магазину 
   * @return payoutToolID
  **/
  @ApiModelProperty(value = "Идентификатор средства вывода в рамках контракта, используемое в процессе вывода по магазину ")


  public String getPayoutToolID() {
    return payoutToolID;
  }

  public void setPayoutToolID(String payoutToolID) {
    this.payoutToolID = payoutToolID;
  }

  public Shop scheduleID(Integer scheduleID) {
    this.scheduleID = scheduleID;
    return this;
  }

  /**
   * Идентификатор расписания выводов
   * @return scheduleID
  **/
  @ApiModelProperty(value = "Идентификатор расписания выводов")


  public Integer getScheduleID() {
    return scheduleID;
  }

  public void setScheduleID(Integer scheduleID) {
    this.scheduleID = scheduleID;
  }

  public Shop account(ShopAccount account) {
    this.account = account;
    return this;
  }

  /**
   * Get account
   * @return account
  **/
  @ApiModelProperty(value = "")

  @Valid

  public ShopAccount getAccount() {
    return account;
  }

  public void setAccount(ShopAccount account) {
    this.account = account;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Shop shop = (Shop) o;
    return Objects.equals(this.id, shop.id) &&
        Objects.equals(this.createdAt, shop.createdAt) &&
        Objects.equals(this.isBlocked, shop.isBlocked) &&
        Objects.equals(this.isSuspended, shop.isSuspended) &&
        Objects.equals(this.categoryID, shop.categoryID) &&
        Objects.equals(this.location, shop.location) &&
        Objects.equals(this.details, shop.details) &&
        Objects.equals(this.contractID, shop.contractID) &&
        Objects.equals(this.payoutToolID, shop.payoutToolID) &&
        Objects.equals(this.scheduleID, shop.scheduleID) &&
        Objects.equals(this.account, shop.account);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdAt, isBlocked, isSuspended, categoryID, location, details, contractID, payoutToolID, scheduleID, account);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Shop {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    isBlocked: ").append(toIndentedString(isBlocked)).append("\n");
    sb.append("    isSuspended: ").append(toIndentedString(isSuspended)).append("\n");
    sb.append("    categoryID: ").append(toIndentedString(categoryID)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("    contractID: ").append(toIndentedString(contractID)).append("\n");
    sb.append("    payoutToolID: ").append(toIndentedString(payoutToolID)).append("\n");
    sb.append("    scheduleID: ").append(toIndentedString(scheduleID)).append("\n");
    sb.append("    account: ").append(toIndentedString(account)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

