package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Данные ошибки, возникшей в процессе проведения возврата, в случае если возврат был неуспешен 
 */
@ApiModel(description = "Данные ошибки, возникшей в процессе проведения возврата, в случае если возврат был неуспешен ")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class RefundStatusError   {
  @JsonProperty("code")
  private String code = null;

  @JsonProperty("message")
  private String message = null;

  public RefundStatusError code(String code) {
    this.code = code;
    return this;
  }

  /**
   * Код ошибки, пригодный для обработки автоматическими системами
   * @return code
  **/
  @ApiModelProperty(required = true, value = "Код ошибки, пригодный для обработки автоматическими системами")
  @NotNull


  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public RefundStatusError message(String message) {
    this.message = message;
    return this;
  }

  /**
   * Описание ошибки, пригодное для восприятия человеком
   * @return message
  **/
  @ApiModelProperty(required = true, value = "Описание ошибки, пригодное для восприятия человеком")
  @NotNull


  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RefundStatusError refundStatusError = (RefundStatusError) o;
    return Objects.equals(this.code, refundStatusError.code) &&
        Objects.equals(this.message, refundStatusError.message);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RefundStatusError {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

