package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.Refund;
import dev.vality.swag.analytics.model.RefundStatusError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * RefundSearchResult
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class RefundSearchResult   {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("externalID")
  private String externalID = null;

  @JsonProperty("createdAt")
  private OffsetDateTime createdAt = null;

  @JsonProperty("amount")
  private Long amount = null;

  @JsonProperty("currency")
  private String currency = null;

  @JsonProperty("reason")
  private String reason = null;

  @JsonProperty("shopID")
  private String shopID = null;

  /**
   * Статус возврата
   */
  public enum StatusEnum {
    PENDING("pending"),
    
    SUCCEEDED("succeeded"),
    
    FAILED("failed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("status")
  private StatusEnum status = null;

  @JsonProperty("error")
  private RefundStatusError error = null;

  @JsonProperty("invoiceID")
  private String invoiceID = null;

  @JsonProperty("paymentID")
  private String paymentID = null;

  public RefundSearchResult id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор возврата
   * @return id
  **/
  @ApiModelProperty(required = true, value = "Идентификатор возврата")
  @NotNull


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public RefundSearchResult externalID(String externalID) {
    this.externalID = externalID;
    return this;
  }

  /**
   * Внешний идентификатор
   * @return externalID
  **/
  @ApiModelProperty(value = "Внешний идентификатор")


  public String getExternalID() {
    return externalID;
  }

  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }

  public RefundSearchResult createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Дата и время осуществления
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "Дата и время осуществления")
  @NotNull

  @Valid

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public RefundSearchResult amount(Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Сумма возврата, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. 
   * minimum: 1
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "Сумма возврата, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. ")
  @NotNull

@Min(1)
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public RefundSearchResult currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).
   * @return currency
  **/
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
  @NotNull

@Pattern(regexp="^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public RefundSearchResult reason(String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * Причина осуществления возврата
   * @return reason
  **/
  @ApiModelProperty(value = "Причина осуществления возврата")


  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  public RefundSearchResult shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

  /**
   * Идентификатор магазина
   * @return shopID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор магазина")
  @NotNull


  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public RefundSearchResult status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Статус возврата
   * @return status
  **/
  @ApiModelProperty(required = true, value = "Статус возврата")
  @NotNull


  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public RefundSearchResult error(RefundStatusError error) {
    this.error = error;
    return this;
  }

  /**
   * Get error
   * @return error
  **/
  @ApiModelProperty(value = "")

  @Valid

  public RefundStatusError getError() {
    return error;
  }

  public void setError(RefundStatusError error) {
    this.error = error;
  }

  public RefundSearchResult invoiceID(String invoiceID) {
    this.invoiceID = invoiceID;
    return this;
  }

  /**
   * Идентификатор инвойса
   * @return invoiceID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор инвойса")
  @NotNull


  public String getInvoiceID() {
    return invoiceID;
  }

  public void setInvoiceID(String invoiceID) {
    this.invoiceID = invoiceID;
  }

  public RefundSearchResult paymentID(String paymentID) {
    this.paymentID = paymentID;
    return this;
  }

  /**
   * Идентификатор платежа
   * @return paymentID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор платежа")
  @NotNull


  public String getPaymentID() {
    return paymentID;
  }

  public void setPaymentID(String paymentID) {
    this.paymentID = paymentID;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RefundSearchResult refundSearchResult = (RefundSearchResult) o;
    return Objects.equals(this.id, refundSearchResult.id) &&
        Objects.equals(this.externalID, refundSearchResult.externalID) &&
        Objects.equals(this.createdAt, refundSearchResult.createdAt) &&
        Objects.equals(this.amount, refundSearchResult.amount) &&
        Objects.equals(this.currency, refundSearchResult.currency) &&
        Objects.equals(this.reason, refundSearchResult.reason) &&
        Objects.equals(this.shopID, refundSearchResult.shopID) &&
        Objects.equals(this.status, refundSearchResult.status) &&
        Objects.equals(this.error, refundSearchResult.error) &&
        Objects.equals(this.invoiceID, refundSearchResult.invoiceID) &&
        Objects.equals(this.paymentID, refundSearchResult.paymentID);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, externalID, createdAt, amount, currency, reason, shopID, status, error, invoiceID, paymentID);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RefundSearchResult {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    invoiceID: ").append(toIndentedString(invoiceID)).append("\n");
    sb.append("    paymentID: ").append(toIndentedString(paymentID)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

