package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.ContactInfo;
import dev.vality.swag.analytics.model.Payer;
import dev.vality.swag.analytics.model.PaymentRecurrentParent;
import dev.vality.swag.analytics.model.PaymentToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Многоразовое платежное средство на основе другого платежа
 */
@ApiModel(description = "Многоразовое платежное средство на основе другого платежа")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class RecurrentPayer extends Payer  {
  @JsonProperty("contactInfo")
  private ContactInfo contactInfo = null;

  @JsonProperty("recurrentParentPayment")
  private PaymentRecurrentParent recurrentParentPayment = null;

  @JsonProperty("paymentToolToken")
  private String paymentToolToken = null;

  @JsonProperty("paymentToolDetails")
  private PaymentToolDetails paymentToolDetails = null;

  public RecurrentPayer contactInfo(ContactInfo contactInfo) {
    this.contactInfo = contactInfo;
    return this;
  }

  /**
   * Get contactInfo
   * @return contactInfo
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public ContactInfo getContactInfo() {
    return contactInfo;
  }

  public void setContactInfo(ContactInfo contactInfo) {
    this.contactInfo = contactInfo;
  }

  public RecurrentPayer recurrentParentPayment(PaymentRecurrentParent recurrentParentPayment) {
    this.recurrentParentPayment = recurrentParentPayment;
    return this;
  }

  /**
   * Get recurrentParentPayment
   * @return recurrentParentPayment
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public PaymentRecurrentParent getRecurrentParentPayment() {
    return recurrentParentPayment;
  }

  public void setRecurrentParentPayment(PaymentRecurrentParent recurrentParentPayment) {
    this.recurrentParentPayment = recurrentParentPayment;
  }

  public RecurrentPayer paymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
    return this;
  }

  /**
   * Токен платежного средства, предоставленного плательщиком
   * @return paymentToolToken
  **/
  @ApiModelProperty(value = "Токен платежного средства, предоставленного плательщиком")

@Size(max=1000) 
  public String getPaymentToolToken() {
    return paymentToolToken;
  }

  public void setPaymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
  }

  public RecurrentPayer paymentToolDetails(PaymentToolDetails paymentToolDetails) {
    this.paymentToolDetails = paymentToolDetails;
    return this;
  }

  /**
   * Get paymentToolDetails
   * @return paymentToolDetails
  **/
  @ApiModelProperty(value = "")

  @Valid

  public PaymentToolDetails getPaymentToolDetails() {
    return paymentToolDetails;
  }

  public void setPaymentToolDetails(PaymentToolDetails paymentToolDetails) {
    this.paymentToolDetails = paymentToolDetails;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RecurrentPayer recurrentPayer = (RecurrentPayer) o;
    return Objects.equals(this.contactInfo, recurrentPayer.contactInfo) &&
        Objects.equals(this.recurrentParentPayment, recurrentPayer.recurrentParentPayment) &&
        Objects.equals(this.paymentToolToken, recurrentPayer.paymentToolToken) &&
        Objects.equals(this.paymentToolDetails, recurrentPayer.paymentToolDetails) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contactInfo, recurrentParentPayment, paymentToolToken, paymentToolDetails, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RecurrentPayer {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    contactInfo: ").append(toIndentedString(contactInfo)).append("\n");
    sb.append("    recurrentParentPayment: ").append(toIndentedString(recurrentParentPayment)).append("\n");
    sb.append("    paymentToolToken: ").append(toIndentedString(paymentToolToken)).append("\n");
    sb.append("    paymentToolDetails: ").append(toIndentedString(paymentToolDetails)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

