package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag.analytics.model.InternationalBankAccount;
import dev.vality.swag.analytics.model.InternationalBankDetails;
import dev.vality.swag.analytics.model.InternationalCorrespondentBankAccount;
import dev.vality.swag.analytics.model.PayoutToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * PayoutToolDetailsInternationalBankAccount
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class PayoutToolDetailsInternationalBankAccount extends PayoutToolDetails  {
  @JsonProperty("number")
  private String number = null;

  @JsonProperty("iban")
  private String iban = null;

  @JsonProperty("bankDetails")
  private InternationalBankDetails bankDetails = null;

  @JsonProperty("correspondentBankAccount")
  private InternationalCorrespondentBankAccount correspondentBankAccount = null;

  public PayoutToolDetailsInternationalBankAccount number(String number) {
    this.number = number;
    return this;
  }

  /**
   * Номер счёта 
   * @return number
  **/
  @ApiModelProperty(example = "123006951", value = "Номер счёта ")

@Pattern(regexp="^[0-9A-Z]{8,40}$") 
  public String getNumber() {
    return number;
  }

  public void setNumber(String number) {
    this.number = number;
  }

  public PayoutToolDetailsInternationalBankAccount iban(String iban) {
    this.iban = iban;
    return this;
  }

  /**
   * International Bank Account Number [ISO 13616](https://en.wikipedia.org/wiki/International_Bank_Account_Number) 
   * @return iban
  **/
  @ApiModelProperty(example = "GR1601101250000000012300695", value = "International Bank Account Number [ISO 13616](https://en.wikipedia.org/wiki/International_Bank_Account_Number) ")

@Pattern(regexp="^[A-Z0-9]{3,35}$") 
  public String getIban() {
    return iban;
  }

  public void setIban(String iban) {
    this.iban = iban;
  }

  public PayoutToolDetailsInternationalBankAccount bankDetails(InternationalBankDetails bankDetails) {
    this.bankDetails = bankDetails;
    return this;
  }

  /**
   * Get bankDetails
   * @return bankDetails
  **/
  @ApiModelProperty(value = "")

  @Valid

  public InternationalBankDetails getBankDetails() {
    return bankDetails;
  }

  public void setBankDetails(InternationalBankDetails bankDetails) {
    this.bankDetails = bankDetails;
  }

  public PayoutToolDetailsInternationalBankAccount correspondentBankAccount(InternationalCorrespondentBankAccount correspondentBankAccount) {
    this.correspondentBankAccount = correspondentBankAccount;
    return this;
  }

  /**
   * Get correspondentBankAccount
   * @return correspondentBankAccount
  **/
  @ApiModelProperty(value = "")

  @Valid

  public InternationalCorrespondentBankAccount getCorrespondentBankAccount() {
    return correspondentBankAccount;
  }

  public void setCorrespondentBankAccount(InternationalCorrespondentBankAccount correspondentBankAccount) {
    this.correspondentBankAccount = correspondentBankAccount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PayoutToolDetailsInternationalBankAccount payoutToolDetailsInternationalBankAccount = (PayoutToolDetailsInternationalBankAccount) o;
    return Objects.equals(this.number, payoutToolDetailsInternationalBankAccount.number) &&
        Objects.equals(this.iban, payoutToolDetailsInternationalBankAccount.iban) &&
        Objects.equals(this.bankDetails, payoutToolDetailsInternationalBankAccount.bankDetails) &&
        Objects.equals(this.correspondentBankAccount, payoutToolDetailsInternationalBankAccount.correspondentBankAccount) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(number, iban, bankDetails, correspondentBankAccount, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PayoutToolDetailsInternationalBankAccount {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    iban: ").append(toIndentedString(iban)).append("\n");
    sb.append("    bankDetails: ").append(toIndentedString(bankDetails)).append("\n");
    sb.append("    correspondentBankAccount: ").append(toIndentedString(correspondentBankAccount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

