package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag.analytics.model.SubError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * PaymentsSubErrorsDistributionResult
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class PaymentsSubErrorsDistributionResult   {
  @JsonProperty("error")
  private SubError error = null;

  @JsonProperty("percents")
  private Double percents = null;

  public PaymentsSubErrorsDistributionResult error(SubError error) {
    this.error = error;
    return this;
  }

  /**
   * Get error
   * @return error
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public SubError getError() {
    return error;
  }

  public void setError(SubError error) {
    this.error = error;
  }

  public PaymentsSubErrorsDistributionResult percents(Double percents) {
    this.percents = percents;
    return this;
  }

  /**
   * Относительное колличество ошибок в процентах
   * minimum: 0
   * @return percents
  **/
  @ApiModelProperty(required = true, value = "Относительное колличество ошибок в процентах")
  @NotNull

@DecimalMin("0")
  public Double getPercents() {
    return percents;
  }

  public void setPercents(Double percents) {
    this.percents = percents;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentsSubErrorsDistributionResult paymentsSubErrorsDistributionResult = (PaymentsSubErrorsDistributionResult) o;
    return Objects.equals(this.error, paymentsSubErrorsDistributionResult.error) &&
        Objects.equals(this.percents, paymentsSubErrorsDistributionResult.percents);
  }

  @Override
  public int hashCode() {
    return Objects.hash(error, percents);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentsSubErrorsDistributionResult {\n");
    
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    percents: ").append(toIndentedString(percents)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

