package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.PaymentTerminalDetails;
import dev.vality.swag.analytics.model.PaymentToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * PaymentToolDetailsPaymentTerminal
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class PaymentToolDetailsPaymentTerminal extends PaymentToolDetails  {
  /**
   * Провайдер терминальной сети
   */
  public enum ProviderEnum {
    EUROSET("euroset"),
    
    WECHAT("wechat"),
    
    ALIPAY("alipay"),
    
    ZOTAPAY("zotapay"),
    
    QPS("qps"),
    
    UZCARD("uzcard"),
    
    RBS("rbs");

    private String value;

    ProviderEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ProviderEnum fromValue(String text) {
      for (ProviderEnum b : ProviderEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("provider")
  private ProviderEnum provider = null;

  public PaymentToolDetailsPaymentTerminal provider(ProviderEnum provider) {
    this.provider = provider;
    return this;
  }

  /**
   * Провайдер терминальной сети
   * @return provider
  **/
  @ApiModelProperty(required = true, value = "Провайдер терминальной сети")
  @NotNull


  public ProviderEnum getProvider() {
    return provider;
  }

  public void setProvider(ProviderEnum provider) {
    this.provider = provider;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentToolDetailsPaymentTerminal paymentToolDetailsPaymentTerminal = (PaymentToolDetailsPaymentTerminal) o;
    return Objects.equals(this.provider, paymentToolDetailsPaymentTerminal.provider) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(provider, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentToolDetailsPaymentTerminal {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

