package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag.analytics.model.MobileCommerceDetails;
import dev.vality.swag.analytics.model.PaymentToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * PaymentToolDetailsMobileCommerce
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class PaymentToolDetailsMobileCommerce extends PaymentToolDetails  {
  @JsonProperty("phoneNumber")
  private String phoneNumber = null;

  public PaymentToolDetailsMobileCommerce phoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * Маскированый номер мобильного телефона
   * @return phoneNumber
  **/
  @ApiModelProperty(example = "+7******0102", required = true, value = "Маскированый номер мобильного телефона")
  @NotNull

@Pattern(regexp="^\\+\\d\\*{1,10}\\d{2,4}$") 
  public String getPhoneNumber() {
    return phoneNumber;
  }

  public void setPhoneNumber(String phoneNumber) {
    this.phoneNumber = phoneNumber;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentToolDetailsMobileCommerce paymentToolDetailsMobileCommerce = (PaymentToolDetailsMobileCommerce) o;
    return Objects.equals(this.phoneNumber, paymentToolDetailsMobileCommerce.phoneNumber) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(phoneNumber, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentToolDetailsMobileCommerce {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    phoneNumber: ").append(toIndentedString(phoneNumber)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

