package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.BankCardDetails;
import dev.vality.swag.analytics.model.PaymentToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * PaymentToolDetailsBankCard
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class PaymentToolDetailsBankCard extends PaymentToolDetails  {
  @JsonProperty("cardNumberMask")
  private String cardNumberMask = null;

  @JsonProperty("bin")
  private String bin = null;

  @JsonProperty("lastDigits")
  private String lastDigits = null;

  /**
   * Платежная система
   */
  public enum PaymentSystemEnum {
    VISA("visa"),
    
    MASTERCARD("mastercard"),
    
    VISAELECTRON("visaelectron"),
    
    MAESTRO("maestro"),
    
    FORBRUGSFORENINGEN("forbrugsforeningen"),
    
    DANKORT("dankort"),
    
    AMEX("amex"),
    
    DINERSCLUB("dinersclub"),
    
    DISCOVER("discover"),
    
    UNIONPAY("unionpay"),
    
    JCB("jcb"),
    
    NSPKMIR("nspkmir"),
    
    ELO("elo"),
    
    RUPAY("rupay"),
    
    DUMMY("dummy"),
    
    UZCARD("uzcard");

    private String value;

    PaymentSystemEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PaymentSystemEnum fromValue(String text) {
      for (PaymentSystemEnum b : PaymentSystemEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("paymentSystem")
  private PaymentSystemEnum paymentSystem = null;

  /**
   * Провайдер платежных токенов
   */
  public enum TokenProviderEnum {
    APPLEPAY("applepay"),
    
    GOOGLEPAY("googlepay"),
    
    SAMSUNGPAY("samsungpay"),
    
    YANDEXPAY("yandexpay");

    private String value;

    TokenProviderEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TokenProviderEnum fromValue(String text) {
      for (TokenProviderEnum b : TokenProviderEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("tokenProvider")
  private TokenProviderEnum tokenProvider = null;

  public PaymentToolDetailsBankCard cardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
    return this;
  }

  /**
   * Маскированый номер карты
   * @return cardNumberMask
  **/
  @ApiModelProperty(required = true, value = "Маскированый номер карты")
  @NotNull

@Pattern(regexp="^\\d{6,8}\\*+\\d{2,4}$") 
  public String getCardNumberMask() {
    return cardNumberMask;
  }

  public void setCardNumberMask(String cardNumberMask) {
    this.cardNumberMask = cardNumberMask;
  }

  public PaymentToolDetailsBankCard bin(String bin) {
    this.bin = bin;
    return this;
  }

  /**
   * BIN банка-эмитента карты
   * @return bin
  **/
  @ApiModelProperty(value = "BIN банка-эмитента карты")

@Pattern(regexp="^(\\d{0}|\\d{6,8})$") 
  public String getBin() {
    return bin;
  }

  public void setBin(String bin) {
    this.bin = bin;
  }

  public PaymentToolDetailsBankCard lastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
    return this;
  }

  /**
   * Последние цифры номера карты
   * @return lastDigits
  **/
  @ApiModelProperty(value = "Последние цифры номера карты")

@Pattern(regexp="^\\d{2,4}$") 
  public String getLastDigits() {
    return lastDigits;
  }

  public void setLastDigits(String lastDigits) {
    this.lastDigits = lastDigits;
  }

  public PaymentToolDetailsBankCard paymentSystem(PaymentSystemEnum paymentSystem) {
    this.paymentSystem = paymentSystem;
    return this;
  }

  /**
   * Платежная система
   * @return paymentSystem
  **/
  @ApiModelProperty(required = true, value = "Платежная система")
  @NotNull


  public PaymentSystemEnum getPaymentSystem() {
    return paymentSystem;
  }

  public void setPaymentSystem(PaymentSystemEnum paymentSystem) {
    this.paymentSystem = paymentSystem;
  }

  public PaymentToolDetailsBankCard tokenProvider(TokenProviderEnum tokenProvider) {
    this.tokenProvider = tokenProvider;
    return this;
  }

  /**
   * Провайдер платежных токенов
   * @return tokenProvider
  **/
  @ApiModelProperty(value = "Провайдер платежных токенов")


  public TokenProviderEnum getTokenProvider() {
    return tokenProvider;
  }

  public void setTokenProvider(TokenProviderEnum tokenProvider) {
    this.tokenProvider = tokenProvider;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentToolDetailsBankCard paymentToolDetailsBankCard = (PaymentToolDetailsBankCard) o;
    return Objects.equals(this.cardNumberMask, paymentToolDetailsBankCard.cardNumberMask) &&
        Objects.equals(this.bin, paymentToolDetailsBankCard.bin) &&
        Objects.equals(this.lastDigits, paymentToolDetailsBankCard.lastDigits) &&
        Objects.equals(this.paymentSystem, paymentToolDetailsBankCard.paymentSystem) &&
        Objects.equals(this.tokenProvider, paymentToolDetailsBankCard.tokenProvider) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cardNumberMask, bin, lastDigits, paymentSystem, tokenProvider, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentToolDetailsBankCard {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    cardNumberMask: ").append(toIndentedString(cardNumberMask)).append("\n");
    sb.append("    bin: ").append(toIndentedString(bin)).append("\n");
    sb.append("    lastDigits: ").append(toIndentedString(lastDigits)).append("\n");
    sb.append("    paymentSystem: ").append(toIndentedString(paymentSystem)).append("\n");
    sb.append("    tokenProvider: ").append(toIndentedString(tokenProvider)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

