package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Детали платежного средства
 */
@ApiModel(description = "Детали платежного средства")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "detailsType", visible = true )
@JsonSubTypes({
  @JsonSubTypes.Type(value = PaymentToolDetailsCryptoWallet.class, name = "PaymentToolDetailsCryptoWallet"),
  @JsonSubTypes.Type(value = PaymentToolDetailsDigitalWallet.class, name = "PaymentToolDetailsDigitalWallet"),
  @JsonSubTypes.Type(value = PaymentToolDetailsPaymentTerminal.class, name = "PaymentToolDetailsPaymentTerminal"),
  @JsonSubTypes.Type(value = PaymentToolDetailsBankCard.class, name = "PaymentToolDetailsBankCard"),
  @JsonSubTypes.Type(value = PaymentToolDetailsMobileCommerce.class, name = "PaymentToolDetailsMobileCommerce"),
})

public class PaymentToolDetails   {
  @JsonProperty("detailsType")
  private String detailsType = null;

  public PaymentToolDetails detailsType(String detailsType) {
    this.detailsType = detailsType;
    return this;
  }

  /**
   * Тип информации о платежном средстве
   * @return detailsType
  **/
  @ApiModelProperty(required = true, value = "Тип информации о платежном средстве")
  @NotNull


  public String getDetailsType() {
    return detailsType;
  }

  public void setDetailsType(String detailsType) {
    this.detailsType = detailsType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentToolDetails paymentToolDetails = (PaymentToolDetails) o;
    return Objects.equals(this.detailsType, paymentToolDetails.detailsType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(detailsType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentToolDetails {\n");
    
    sb.append("    detailsType: ").append(toIndentedString(detailsType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

