package dev.vality.swag.analytics.model;

import java.util.Objects;
import io.swagger.annotations.ApiModel;
import com.fasterxml.jackson.annotation.JsonValue;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

import com.fasterxml.jackson.annotation.JsonCreator;

/**
 * Провайдер терминальной сети
 */
public enum PaymentTerminalProvider {
  
  EUROSET("euroset"),
  
  WECHAT("wechat"),
  
  ALIPAY("alipay"),
  
  ZOTAPAY("zotapay"),
  
  QPS("qps"),
  
  UZCARD("uzcard"),
  
  RBS("rbs");

  private String value;

  PaymentTerminalProvider(String value) {
    this.value = value;
  }

  @Override
  @JsonValue
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static PaymentTerminalProvider fromValue(String text) {
    for (PaymentTerminalProvider b : PaymentTerminalProvider.values()) {
      if (String.valueOf(b.value).equals(text)) {
        return b;
      }
    }
    return null;
  }
}

