package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.GeoLocationInfo;
import dev.vality.swag.analytics.model.Payer;
import dev.vality.swag.analytics.model.PaymentError;
import dev.vality.swag.analytics.model.PaymentFlow;
import dev.vality.swag.analytics.model.PaymentStatus;
import dev.vality.swag.analytics.model.TransactionInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * PaymentSearchResult
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class PaymentSearchResult   {
  /**
   * Статус платежа
   */
  public enum StatusEnum {
    PENDING("pending"),
    
    PROCESSED("processed"),
    
    CAPTURED("captured"),
    
    CANCELLED("cancelled"),
    
    REFUNDED("refunded"),
    
    FAILED("failed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("status")
  private StatusEnum status = null;

  @JsonProperty("error")
  private PaymentError error = null;

  @JsonProperty("id")
  private String id = null;

  @JsonProperty("shortID")
  private String shortID = null;

  @JsonProperty("invoiceID")
  private String invoiceID = null;

  @JsonProperty("externalID")
  private String externalID = null;

  @JsonProperty("shopID")
  private String shopID = null;

  @JsonProperty("createdAt")
  private OffsetDateTime createdAt = null;

  @JsonProperty("amount")
  private Long amount = null;

  @JsonProperty("fee")
  private Long fee = null;

  @JsonProperty("currency")
  private String currency = null;

  @JsonProperty("payer")
  private Payer payer = null;

  @JsonProperty("flow")
  private PaymentFlow flow = null;

  @JsonProperty("geoLocationInfo")
  private GeoLocationInfo geoLocationInfo = null;

  @JsonProperty("metadata")
  private Object metadata = null;

  @JsonProperty("statusChangedAt")
  private OffsetDateTime statusChangedAt = null;

  @JsonProperty("transactionInfo")
  private TransactionInfo transactionInfo = null;

  @JsonProperty("makeRecurrent")
  private Boolean makeRecurrent = null;

  public PaymentSearchResult status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Статус платежа
   * @return status
  **/
  @ApiModelProperty(required = true, value = "Статус платежа")
  @NotNull


  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public PaymentSearchResult error(PaymentError error) {
    this.error = error;
    return this;
  }

  /**
   * Get error
   * @return error
  **/
  @ApiModelProperty(value = "")

  @Valid

  public PaymentError getError() {
    return error;
  }

  public void setError(PaymentError error) {
    this.error = error;
  }

  public PaymentSearchResult id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор платежа
   * @return id
  **/
  @ApiModelProperty(required = true, value = "Идентификатор платежа")
  @NotNull


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public PaymentSearchResult shortID(String shortID) {
    this.shortID = shortID;
    return this;
  }

  /**
   * Cокращенный идентификатор платежа и инвойса (spid)
   * @return shortID
  **/
  @ApiModelProperty(value = "Cокращенный идентификатор платежа и инвойса (spid)")


  public String getShortID() {
    return shortID;
  }

  public void setShortID(String shortID) {
    this.shortID = shortID;
  }

  public PaymentSearchResult invoiceID(String invoiceID) {
    this.invoiceID = invoiceID;
    return this;
  }

  /**
   * Идентификатор инвойса, в рамках которого был создан платеж
   * @return invoiceID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор инвойса, в рамках которого был создан платеж")
  @NotNull


  public String getInvoiceID() {
    return invoiceID;
  }

  public void setInvoiceID(String invoiceID) {
    this.invoiceID = invoiceID;
  }

  public PaymentSearchResult externalID(String externalID) {
    this.externalID = externalID;
    return this;
  }

  /**
   * Внешний идентификатор
   * @return externalID
  **/
  @ApiModelProperty(value = "Внешний идентификатор")


  public String getExternalID() {
    return externalID;
  }

  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }

  public PaymentSearchResult shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

  /**
   * Идентификатор магазина, в рамках которого был создан платеж
   * @return shopID
  **/
  @ApiModelProperty(value = "Идентификатор магазина, в рамках которого был создан платеж")


  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public PaymentSearchResult createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Дата и время создания
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "Дата и время создания")
  @NotNull

  @Valid

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public PaymentSearchResult amount(Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. 
   * minimum: 1
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. ")
  @NotNull

@Min(1)
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public PaymentSearchResult fee(Long fee) {
    this.fee = fee;
    return this;
  }

  /**
   * Комиссия системы, в минорных денежных единицах
   * minimum: 0
   * @return fee
  **/
  @ApiModelProperty(value = "Комиссия системы, в минорных денежных единицах")

@Min(0)
  public Long getFee() {
    return fee;
  }

  public void setFee(Long fee) {
    this.fee = fee;
  }

  public PaymentSearchResult currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).
   * @return currency
  **/
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
  @NotNull

@Pattern(regexp="^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public PaymentSearchResult payer(Payer payer) {
    this.payer = payer;
    return this;
  }

  /**
   * Get payer
   * @return payer
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public Payer getPayer() {
    return payer;
  }

  public void setPayer(Payer payer) {
    this.payer = payer;
  }

  public PaymentSearchResult flow(PaymentFlow flow) {
    this.flow = flow;
    return this;
  }

  /**
   * Get flow
   * @return flow
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public PaymentFlow getFlow() {
    return flow;
  }

  public void setFlow(PaymentFlow flow) {
    this.flow = flow;
  }

  public PaymentSearchResult geoLocationInfo(GeoLocationInfo geoLocationInfo) {
    this.geoLocationInfo = geoLocationInfo;
    return this;
  }

  /**
   * Get geoLocationInfo
   * @return geoLocationInfo
  **/
  @ApiModelProperty(value = "")

  @Valid

  public GeoLocationInfo getGeoLocationInfo() {
    return geoLocationInfo;
  }

  public void setGeoLocationInfo(GeoLocationInfo geoLocationInfo) {
    this.geoLocationInfo = geoLocationInfo;
  }

  public PaymentSearchResult metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Связанные с платежом метаданные
   * @return metadata
  **/
  @ApiModelProperty(value = "Связанные с платежом метаданные")


  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }

  public PaymentSearchResult statusChangedAt(OffsetDateTime statusChangedAt) {
    this.statusChangedAt = statusChangedAt;
    return this;
  }

  /**
   * Дата и время изменения статуса платежа
   * @return statusChangedAt
  **/
  @ApiModelProperty(value = "Дата и время изменения статуса платежа")

  @Valid

  public OffsetDateTime getStatusChangedAt() {
    return statusChangedAt;
  }

  public void setStatusChangedAt(OffsetDateTime statusChangedAt) {
    this.statusChangedAt = statusChangedAt;
  }

  public PaymentSearchResult transactionInfo(TransactionInfo transactionInfo) {
    this.transactionInfo = transactionInfo;
    return this;
  }

  /**
   * Get transactionInfo
   * @return transactionInfo
  **/
  @ApiModelProperty(value = "")

  @Valid

  public TransactionInfo getTransactionInfo() {
    return transactionInfo;
  }

  public void setTransactionInfo(TransactionInfo transactionInfo) {
    this.transactionInfo = transactionInfo;
  }

  public PaymentSearchResult makeRecurrent(Boolean makeRecurrent) {
    this.makeRecurrent = makeRecurrent;
    return this;
  }

  /**
   * Get makeRecurrent
   * @return makeRecurrent
  **/
  @ApiModelProperty(value = "")


  public Boolean getMakeRecurrent() {
    return makeRecurrent;
  }

  public void setMakeRecurrent(Boolean makeRecurrent) {
    this.makeRecurrent = makeRecurrent;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentSearchResult paymentSearchResult = (PaymentSearchResult) o;
    return Objects.equals(this.status, paymentSearchResult.status) &&
        Objects.equals(this.error, paymentSearchResult.error) &&
        Objects.equals(this.id, paymentSearchResult.id) &&
        Objects.equals(this.shortID, paymentSearchResult.shortID) &&
        Objects.equals(this.invoiceID, paymentSearchResult.invoiceID) &&
        Objects.equals(this.externalID, paymentSearchResult.externalID) &&
        Objects.equals(this.shopID, paymentSearchResult.shopID) &&
        Objects.equals(this.createdAt, paymentSearchResult.createdAt) &&
        Objects.equals(this.amount, paymentSearchResult.amount) &&
        Objects.equals(this.fee, paymentSearchResult.fee) &&
        Objects.equals(this.currency, paymentSearchResult.currency) &&
        Objects.equals(this.payer, paymentSearchResult.payer) &&
        Objects.equals(this.flow, paymentSearchResult.flow) &&
        Objects.equals(this.geoLocationInfo, paymentSearchResult.geoLocationInfo) &&
        Objects.equals(this.metadata, paymentSearchResult.metadata) &&
        Objects.equals(this.statusChangedAt, paymentSearchResult.statusChangedAt) &&
        Objects.equals(this.transactionInfo, paymentSearchResult.transactionInfo) &&
        Objects.equals(this.makeRecurrent, paymentSearchResult.makeRecurrent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, error, id, shortID, invoiceID, externalID, shopID, createdAt, amount, fee, currency, payer, flow, geoLocationInfo, metadata, statusChangedAt, transactionInfo, makeRecurrent);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentSearchResult {\n");
    
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    shortID: ").append(toIndentedString(shortID)).append("\n");
    sb.append("    invoiceID: ").append(toIndentedString(invoiceID)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    fee: ").append(toIndentedString(fee)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    payer: ").append(toIndentedString(payer)).append("\n");
    sb.append("    flow: ").append(toIndentedString(flow)).append("\n");
    sb.append("    geoLocationInfo: ").append(toIndentedString(geoLocationInfo)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    statusChangedAt: ").append(toIndentedString(statusChangedAt)).append("\n");
    sb.append("    transactionInfo: ").append(toIndentedString(transactionInfo)).append("\n");
    sb.append("    makeRecurrent: ").append(toIndentedString(makeRecurrent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

