package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.ContactInfo;
import dev.vality.swag.analytics.model.Payer;
import dev.vality.swag.analytics.model.PaymentResource;
import dev.vality.swag.analytics.model.PaymentToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Одноразовое платежное средство
 */
@ApiModel(description = "Одноразовое платежное средство")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class PaymentResourcePayer extends Payer  {
  @JsonProperty("paymentToolToken")
  private String paymentToolToken = null;

  @JsonProperty("paymentSession")
  private String paymentSession = null;

  @JsonProperty("paymentToolDetails")
  private PaymentToolDetails paymentToolDetails = null;

  @JsonProperty("contactInfo")
  private ContactInfo contactInfo = null;

  public PaymentResourcePayer paymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
    return this;
  }

  /**
   * Токен платежного средства, предоставленного плательщиком
   * @return paymentToolToken
  **/
  @ApiModelProperty(required = true, value = "Токен платежного средства, предоставленного плательщиком")
  @NotNull

@Size(max=1000) 
  public String getPaymentToolToken() {
    return paymentToolToken;
  }

  public void setPaymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
  }

  public PaymentResourcePayer paymentSession(String paymentSession) {
    this.paymentSession = paymentSession;
    return this;
  }

  /**
   * Идентификатор платежной сессии
   * @return paymentSession
  **/
  @ApiModelProperty(value = "Идентификатор платежной сессии")

@Size(max=1000) 
  public String getPaymentSession() {
    return paymentSession;
  }

  public void setPaymentSession(String paymentSession) {
    this.paymentSession = paymentSession;
  }

  public PaymentResourcePayer paymentToolDetails(PaymentToolDetails paymentToolDetails) {
    this.paymentToolDetails = paymentToolDetails;
    return this;
  }

  /**
   * Get paymentToolDetails
   * @return paymentToolDetails
  **/
  @ApiModelProperty(value = "")

  @Valid

  public PaymentToolDetails getPaymentToolDetails() {
    return paymentToolDetails;
  }

  public void setPaymentToolDetails(PaymentToolDetails paymentToolDetails) {
    this.paymentToolDetails = paymentToolDetails;
  }

  public PaymentResourcePayer contactInfo(ContactInfo contactInfo) {
    this.contactInfo = contactInfo;
    return this;
  }

  /**
   * Get contactInfo
   * @return contactInfo
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public ContactInfo getContactInfo() {
    return contactInfo;
  }

  public void setContactInfo(ContactInfo contactInfo) {
    this.contactInfo = contactInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentResourcePayer paymentResourcePayer = (PaymentResourcePayer) o;
    return Objects.equals(this.paymentToolToken, paymentResourcePayer.paymentToolToken) &&
        Objects.equals(this.paymentSession, paymentResourcePayer.paymentSession) &&
        Objects.equals(this.paymentToolDetails, paymentResourcePayer.paymentToolDetails) &&
        Objects.equals(this.contactInfo, paymentResourcePayer.contactInfo) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentToolToken, paymentSession, paymentToolDetails, contactInfo, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentResourcePayer {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    paymentToolToken: ").append(toIndentedString(paymentToolToken)).append("\n");
    sb.append("    paymentSession: ").append(toIndentedString(paymentSession)).append("\n");
    sb.append("    paymentToolDetails: ").append(toIndentedString(paymentToolDetails)).append("\n");
    sb.append("    contactInfo: ").append(toIndentedString(contactInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

