package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag.analytics.model.PaymentToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Данные одноразового платежного средства
 */
@ApiModel(description = "Данные одноразового платежного средства")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class PaymentResource   {
  @JsonProperty("paymentToolToken")
  private String paymentToolToken = null;

  @JsonProperty("paymentSession")
  private String paymentSession = null;

  @JsonProperty("paymentToolDetails")
  private PaymentToolDetails paymentToolDetails = null;

  public PaymentResource paymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
    return this;
  }

  /**
   * Токен платежного средства, предоставленного плательщиком
   * @return paymentToolToken
  **/
  @ApiModelProperty(required = true, value = "Токен платежного средства, предоставленного плательщиком")
  @NotNull

@Size(max=1000) 
  public String getPaymentToolToken() {
    return paymentToolToken;
  }

  public void setPaymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
  }

  public PaymentResource paymentSession(String paymentSession) {
    this.paymentSession = paymentSession;
    return this;
  }

  /**
   * Идентификатор платежной сессии
   * @return paymentSession
  **/
  @ApiModelProperty(value = "Идентификатор платежной сессии")

@Size(max=1000) 
  public String getPaymentSession() {
    return paymentSession;
  }

  public void setPaymentSession(String paymentSession) {
    this.paymentSession = paymentSession;
  }

  public PaymentResource paymentToolDetails(PaymentToolDetails paymentToolDetails) {
    this.paymentToolDetails = paymentToolDetails;
    return this;
  }

  /**
   * Get paymentToolDetails
   * @return paymentToolDetails
  **/
  @ApiModelProperty(value = "")

  @Valid

  public PaymentToolDetails getPaymentToolDetails() {
    return paymentToolDetails;
  }

  public void setPaymentToolDetails(PaymentToolDetails paymentToolDetails) {
    this.paymentToolDetails = paymentToolDetails;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentResource paymentResource = (PaymentResource) o;
    return Objects.equals(this.paymentToolToken, paymentResource.paymentToolToken) &&
        Objects.equals(this.paymentSession, paymentResource.paymentSession) &&
        Objects.equals(this.paymentToolDetails, paymentResource.paymentToolDetails);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentToolToken, paymentSession, paymentToolDetails);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentResource {\n");
    
    sb.append("    paymentToolToken: ").append(toIndentedString(paymentToolToken)).append("\n");
    sb.append("    paymentSession: ").append(toIndentedString(paymentSession)).append("\n");
    sb.append("    paymentToolDetails: ").append(toIndentedString(paymentToolDetails)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

