package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag.analytics.model.SubError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * [Ошибка, возникшая в процессе проведения платежа](#tag/Error-Codes) 
 */
@ApiModel(description = "[Ошибка, возникшая в процессе проведения платежа](#tag/Error-Codes) ")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class PaymentError   {
  @JsonProperty("code")
  private String code = null;

  @JsonProperty("subError")
  private SubError subError = null;

  public PaymentError code(String code) {
    this.code = code;
    return this;
  }

  /**
   * Основной код ошибки
   * @return code
  **/
  @ApiModelProperty(required = true, value = "Основной код ошибки")
  @NotNull


  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public PaymentError subError(SubError subError) {
    this.subError = subError;
    return this;
  }

  /**
   * Get subError
   * @return subError
  **/
  @ApiModelProperty(value = "")

  @Valid

  public SubError getSubError() {
    return subError;
  }

  public void setSubError(SubError subError) {
    this.subError = subError;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentError paymentError = (PaymentError) o;
    return Objects.equals(this.code, paymentError.code) &&
        Objects.equals(this.subError, paymentError.subError);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, subError);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentError {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    subError: ").append(toIndentedString(subError)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

