package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Payer
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "payerType", visible = true )
@JsonSubTypes({
  @JsonSubTypes.Type(value = CustomerPayer.class, name = "CustomerPayer"),
  @JsonSubTypes.Type(value = RecurrentPayer.class, name = "RecurrentPayer"),
  @JsonSubTypes.Type(value = PaymentResourcePayer.class, name = "PaymentResourcePayer"),
})

public class Payer   {
  /**
   * Тип платежного средства
   */
  public enum PayerTypeEnum {
    CUSTOMERPAYER("CustomerPayer"),
    
    PAYMENTRESOURCEPAYER("PaymentResourcePayer"),
    
    RECURRENTPAYER("RecurrentPayer");

    private String value;

    PayerTypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PayerTypeEnum fromValue(String text) {
      for (PayerTypeEnum b : PayerTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("payerType")
  private PayerTypeEnum payerType = null;

  public Payer payerType(PayerTypeEnum payerType) {
    this.payerType = payerType;
    return this;
  }

  /**
   * Тип платежного средства
   * @return payerType
  **/
  @ApiModelProperty(required = true, value = "Тип платежного средства")
  @NotNull


  public PayerTypeEnum getPayerType() {
    return payerType;
  }

  public void setPayerType(PayerTypeEnum payerType) {
    this.payerType = payerType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Payer payer = (Payer) o;
    return Objects.equals(this.payerType, payer.payerType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(payerType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Payer {\n");
    
    sb.append("    payerType: ").append(toIndentedString(payerType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

