package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.InvoiceLineTaxMode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * InvoiceLineTaxVAT
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class InvoiceLineTaxVAT extends InvoiceLineTaxMode  {
  /**
   * Ставка налога
   */
  public enum RateEnum {
    _0_("0%"),
    
    _10_("10%"),
    
    _18_("18%"),
    
    _20_("20%"),
    
    _10_110("10/110"),
    
    _18_118("18/118"),
    
    _20_120("20/120");

    private String value;

    RateEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RateEnum fromValue(String text) {
      for (RateEnum b : RateEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("rate")
  private RateEnum rate = null;

  public InvoiceLineTaxVAT rate(RateEnum rate) {
    this.rate = rate;
    return this;
  }

  /**
   * Ставка налога
   * @return rate
  **/
  @ApiModelProperty(required = true, value = "Ставка налога")
  @NotNull


  public RateEnum getRate() {
    return rate;
  }

  public void setRate(RateEnum rate) {
    this.rate = rate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceLineTaxVAT invoiceLineTaxVAT = (InvoiceLineTaxVAT) o;
    return Objects.equals(this.rate, invoiceLineTaxVAT.rate) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rate, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceLineTaxVAT {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    rate: ").append(toIndentedString(rate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

