package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.InvoiceCart;
import dev.vality.swag.analytics.model.InvoiceStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Invoice
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class Invoice   {
  /**
   * Статус инвойса
   */
  public enum StatusEnum {
    UNPAID("unpaid"),
    
    CANCELLED("cancelled"),
    
    PAID("paid"),
    
    FULFILLED("fulfilled");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("status")
  private StatusEnum status = null;

  @JsonProperty("reason")
  private String reason = null;

  @JsonProperty("id")
  private String id = null;

  @JsonProperty("externalID")
  private String externalID = null;

  @JsonProperty("shopID")
  private String shopID = null;

  @JsonProperty("createdAt")
  private OffsetDateTime createdAt = null;

  @JsonProperty("dueDate")
  private OffsetDateTime dueDate = null;

  @JsonProperty("amount")
  private Long amount = null;

  @JsonProperty("currency")
  private String currency = null;

  @JsonProperty("product")
  private String product = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("invoiceTemplateID")
  private String invoiceTemplateID = null;

  @JsonProperty("cart")
  private InvoiceCart cart = null;

  @JsonProperty("metadata")
  private Object metadata = null;

  public Invoice status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Статус инвойса
   * @return status
  **/
  @ApiModelProperty(required = true, value = "Статус инвойса")
  @NotNull


  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public Invoice reason(String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * Причина отмены или погашения инвойса
   * @return reason
  **/
  @ApiModelProperty(value = "Причина отмены или погашения инвойса")

@Size(max=1000) 
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  public Invoice id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор инвойса
   * @return id
  **/
  @ApiModelProperty(required = true, value = "Идентификатор инвойса")
  @NotNull


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Invoice externalID(String externalID) {
    this.externalID = externalID;
    return this;
  }

  /**
   * Внешний идентификатор
   * @return externalID
  **/
  @ApiModelProperty(value = "Внешний идентификатор")


  public String getExternalID() {
    return externalID;
  }

  public void setExternalID(String externalID) {
    this.externalID = externalID;
  }

  public Invoice shopID(String shopID) {
    this.shopID = shopID;
    return this;
  }

  /**
   * Идентификатор магазина
   * @return shopID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор магазина")
  @NotNull


  public String getShopID() {
    return shopID;
  }

  public void setShopID(String shopID) {
    this.shopID = shopID;
  }

  public Invoice createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Дата и время создания
   * @return createdAt
  **/
  @ApiModelProperty(required = true, value = "Дата и время создания")
  @NotNull

  @Valid

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public Invoice dueDate(OffsetDateTime dueDate) {
    this.dueDate = dueDate;
    return this;
  }

  /**
   * Дата и время окончания действия
   * @return dueDate
  **/
  @ApiModelProperty(required = true, value = "Дата и время окончания действия")
  @NotNull

  @Valid

  public OffsetDateTime getDueDate() {
    return dueDate;
  }

  public void setDueDate(OffsetDateTime dueDate) {
    this.dueDate = dueDate;
  }

  public Invoice amount(Long amount) {
    this.amount = amount;
    return this;
  }

  /**
   * Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. 
   * minimum: 1
   * @return amount
  **/
  @ApiModelProperty(required = true, value = "Стоимость предлагаемых товаров или услуг, в минорных денежных единицах, например в копейках в случае указания российских рублей в качестве валюты. ")
  @NotNull

@Min(1)
  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public Invoice currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).
   * @return currency
  **/
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
  @NotNull

@Pattern(regexp="^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }

  public Invoice product(String product) {
    this.product = product;
    return this;
  }

  /**
   * Наименование предлагаемых товаров или услуг
   * @return product
  **/
  @ApiModelProperty(required = true, value = "Наименование предлагаемых товаров или услуг")
  @NotNull

@Size(max=100) 
  public String getProduct() {
    return product;
  }

  public void setProduct(String product) {
    this.product = product;
  }

  public Invoice description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Описание предлагаемых товаров или услуг
   * @return description
  **/
  @ApiModelProperty(value = "Описание предлагаемых товаров или услуг")

@Size(max=1000) 
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Invoice invoiceTemplateID(String invoiceTemplateID) {
    this.invoiceTemplateID = invoiceTemplateID;
    return this;
  }

  /**
   * Идентификатор шаблона (для инвойсов, созданных по шаблону).
   * @return invoiceTemplateID
  **/
  @ApiModelProperty(value = "Идентификатор шаблона (для инвойсов, созданных по шаблону).")


  public String getInvoiceTemplateID() {
    return invoiceTemplateID;
  }

  public void setInvoiceTemplateID(String invoiceTemplateID) {
    this.invoiceTemplateID = invoiceTemplateID;
  }

  public Invoice cart(InvoiceCart cart) {
    this.cart = cart;
    return this;
  }

  /**
   * Get cart
   * @return cart
  **/
  @ApiModelProperty(value = "")

  @Valid

  public InvoiceCart getCart() {
    return cart;
  }

  public void setCart(InvoiceCart cart) {
    this.cart = cart;
  }

  public Invoice metadata(Object metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Связанные с инвойсом метаданные
   * @return metadata
  **/
  @ApiModelProperty(required = true, value = "Связанные с инвойсом метаданные")
  @NotNull


  public Object getMetadata() {
    return metadata;
  }

  public void setMetadata(Object metadata) {
    this.metadata = metadata;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Invoice invoice = (Invoice) o;
    return Objects.equals(this.status, invoice.status) &&
        Objects.equals(this.reason, invoice.reason) &&
        Objects.equals(this.id, invoice.id) &&
        Objects.equals(this.externalID, invoice.externalID) &&
        Objects.equals(this.shopID, invoice.shopID) &&
        Objects.equals(this.createdAt, invoice.createdAt) &&
        Objects.equals(this.dueDate, invoice.dueDate) &&
        Objects.equals(this.amount, invoice.amount) &&
        Objects.equals(this.currency, invoice.currency) &&
        Objects.equals(this.product, invoice.product) &&
        Objects.equals(this.description, invoice.description) &&
        Objects.equals(this.invoiceTemplateID, invoice.invoiceTemplateID) &&
        Objects.equals(this.cart, invoice.cart) &&
        Objects.equals(this.metadata, invoice.metadata);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, reason, id, externalID, shopID, createdAt, dueDate, amount, currency, product, description, invoiceTemplateID, cart, metadata);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Invoice {\n");
    
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    externalID: ").append(toIndentedString(externalID)).append("\n");
    sb.append("    shopID: ").append(toIndentedString(shopID)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    product: ").append(toIndentedString(product)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    invoiceTemplateID: ").append(toIndentedString(invoiceTemplateID)).append("\n");
    sb.append("    cart: ").append(toIndentedString(cart)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

