package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag.analytics.model.FileMetaSignatures;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * FileMeta
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class FileMeta   {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("filename")
  private String filename = null;

  @JsonProperty("signatures")
  private FileMetaSignatures signatures = null;

  public FileMeta id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Идентификатор файла
   * @return id
  **/
  @ApiModelProperty(required = true, value = "Идентификатор файла")
  @NotNull

@Size(min=1,max=40) 
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public FileMeta filename(String filename) {
    this.filename = filename;
    return this;
  }

  /**
   * Имя файла
   * @return filename
  **/
  @ApiModelProperty(required = true, value = "Имя файла")
  @NotNull

@Size(min=1,max=1000) 
  public String getFilename() {
    return filename;
  }

  public void setFilename(String filename) {
    this.filename = filename;
  }

  public FileMeta signatures(FileMetaSignatures signatures) {
    this.signatures = signatures;
    return this;
  }

  /**
   * Get signatures
   * @return signatures
  **/
  @ApiModelProperty(value = "")

  @Valid

  public FileMetaSignatures getSignatures() {
    return signatures;
  }

  public void setSignatures(FileMetaSignatures signatures) {
    this.signatures = signatures;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FileMeta fileMeta = (FileMeta) o;
    return Objects.equals(this.id, fileMeta.id) &&
        Objects.equals(this.filename, fileMeta.filename) &&
        Objects.equals(this.signatures, fileMeta.signatures);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, filename, signatures);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FileMeta {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    filename: ").append(toIndentedString(filename)).append("\n");
    sb.append("    signatures: ").append(toIndentedString(signatures)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

