package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.DigitalWalletDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * DigitalWalletDetailsQIWI
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class DigitalWalletDetailsQIWI extends DigitalWalletDetails  {
  @JsonProperty("phoneNumberMask")
  private String phoneNumberMask = null;

  public DigitalWalletDetailsQIWI phoneNumberMask(String phoneNumberMask) {
    this.phoneNumberMask = phoneNumberMask;
    return this;
  }

  /**
   * Маскированный номер телефона плательщика в международном формате, выступающий в роли идентификатора кошелька Visa QIWI Wallet. 
   * @return phoneNumberMask
  **/
  @ApiModelProperty(example = "+7******3210", required = true, value = "Маскированный номер телефона плательщика в международном формате, выступающий в роли идентификатора кошелька Visa QIWI Wallet. ")
  @NotNull

@Pattern(regexp="^\\+\\d\\*{1,10}\\d{2,4}$") 
  public String getPhoneNumberMask() {
    return phoneNumberMask;
  }

  public void setPhoneNumberMask(String phoneNumberMask) {
    this.phoneNumberMask = phoneNumberMask;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DigitalWalletDetailsQIWI digitalWalletDetailsQIWI = (DigitalWalletDetailsQIWI) o;
    return Objects.equals(this.phoneNumberMask, digitalWalletDetailsQIWI.phoneNumberMask) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(phoneNumberMask, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DigitalWalletDetailsQIWI {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    phoneNumberMask: ").append(toIndentedString(phoneNumberMask)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

