package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.vality.swag.analytics.model.Payer;
import dev.vality.swag.analytics.model.PaymentToolDetails;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Многоразовое платежное средство
 */
@ApiModel(description = "Многоразовое платежное средство")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class CustomerPayer extends Payer  {
  @JsonProperty("customerID")
  private String customerID = null;

  @JsonProperty("paymentToolToken")
  private String paymentToolToken = null;

  @JsonProperty("paymentToolDetails")
  private PaymentToolDetails paymentToolDetails = null;

  public CustomerPayer customerID(String customerID) {
    this.customerID = customerID;
    return this;
  }

  /**
   * Идентификатор плательщика
   * @return customerID
  **/
  @ApiModelProperty(required = true, value = "Идентификатор плательщика")
  @NotNull

@Size(min=1,max=40) 
  public String getCustomerID() {
    return customerID;
  }

  public void setCustomerID(String customerID) {
    this.customerID = customerID;
  }

  public CustomerPayer paymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
    return this;
  }

  /**
   * Токен платежного средства, предоставленного плательщиком
   * @return paymentToolToken
  **/
  @ApiModelProperty(value = "Токен платежного средства, предоставленного плательщиком")

@Size(max=1000) 
  public String getPaymentToolToken() {
    return paymentToolToken;
  }

  public void setPaymentToolToken(String paymentToolToken) {
    this.paymentToolToken = paymentToolToken;
  }

  public CustomerPayer paymentToolDetails(PaymentToolDetails paymentToolDetails) {
    this.paymentToolDetails = paymentToolDetails;
    return this;
  }

  /**
   * Get paymentToolDetails
   * @return paymentToolDetails
  **/
  @ApiModelProperty(value = "")

  @Valid

  public PaymentToolDetails getPaymentToolDetails() {
    return paymentToolDetails;
  }

  public void setPaymentToolDetails(PaymentToolDetails paymentToolDetails) {
    this.paymentToolDetails = paymentToolDetails;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CustomerPayer customerPayer = (CustomerPayer) o;
    return Objects.equals(this.customerID, customerPayer.customerID) &&
        Objects.equals(this.paymentToolToken, customerPayer.paymentToolToken) &&
        Objects.equals(this.paymentToolDetails, customerPayer.paymentToolDetails) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerID, paymentToolToken, paymentToolDetails, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CustomerPayer {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    customerID: ").append(toIndentedString(customerID)).append("\n");
    sb.append("    paymentToolToken: ").append(toIndentedString(paymentToolToken)).append("\n");
    sb.append("    paymentToolDetails: ").append(toIndentedString(paymentToolDetails)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

