package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * CryptoWalletDetails
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class CryptoWalletDetails   {
  /**
   * Тип криптовалюты
   */
  public enum CryptoCurrencyEnum {
    BITCOIN("bitcoin"),
    
    LITECOIN("litecoin"),
    
    BITCOINCASH("bitcoinCash"),
    
    RIPPLE("ripple"),
    
    ETHEREUM("ethereum"),
    
    ZCASH("zcash");

    private String value;

    CryptoCurrencyEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CryptoCurrencyEnum fromValue(String text) {
      for (CryptoCurrencyEnum b : CryptoCurrencyEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("cryptoCurrency")
  private CryptoCurrencyEnum cryptoCurrency = null;

  public CryptoWalletDetails cryptoCurrency(CryptoCurrencyEnum cryptoCurrency) {
    this.cryptoCurrency = cryptoCurrency;
    return this;
  }

  /**
   * Тип криптовалюты
   * @return cryptoCurrency
  **/
  @ApiModelProperty(required = true, value = "Тип криптовалюты")
  @NotNull


  public CryptoCurrencyEnum getCryptoCurrency() {
    return cryptoCurrency;
  }

  public void setCryptoCurrency(CryptoCurrencyEnum cryptoCurrency) {
    this.cryptoCurrency = cryptoCurrency;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CryptoWalletDetails cryptoWalletDetails = (CryptoWalletDetails) o;
    return Objects.equals(this.cryptoCurrency, cryptoWalletDetails.cryptoCurrency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cryptoCurrency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CryptoWalletDetails {\n");
    
    sb.append("    cryptoCurrency: ").append(toIndentedString(cryptoCurrency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

