package dev.vality.swag.analytics.model;

import java.util.Objects;
import io.swagger.annotations.ApiModel;
import com.fasterxml.jackson.annotation.JsonValue;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

import com.fasterxml.jackson.annotation.JsonCreator;

/**
 * Тип криптовалюты
 */
public enum CryptoCurrency {
  
  BITCOIN("bitcoin"),
  
  LITECOIN("litecoin"),
  
  BITCOINCASH("bitcoinCash"),
  
  RIPPLE("ripple"),
  
  ETHEREUM("ethereum"),
  
  ZCASH("zcash");

  private String value;

  CryptoCurrency(String value) {
    this.value = value;
  }

  @Override
  @JsonValue
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static CryptoCurrency fromValue(String text) {
    for (CryptoCurrency b : CryptoCurrency.values()) {
      if (String.valueOf(b.value).equals(text)) {
        return b;
      }
    }
    return null;
  }
}

