package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * CountResult
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class CountResult   {
  @JsonProperty("count")
  private Long count = null;

  @JsonProperty("currency")
  private String currency = null;

  public CountResult count(Long count) {
    this.count = count;
    return this;
  }

  /**
   * Общее количество операций
   * minimum: 0
   * @return count
  **/
  @ApiModelProperty(required = true, value = "Общее количество операций")
  @NotNull

@Min(0)
  public Long getCount() {
    return count;
  }

  public void setCount(Long count) {
    this.count = count;
  }

  public CountResult currency(String currency) {
    this.currency = currency;
    return this;
  }

  /**
   * Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).
   * @return currency
  **/
  @ApiModelProperty(required = true, value = "Валюта, символьный код согласно [ISO 4217](http://www.iso.org/iso/home/standards/currency_codes.htm).")
  @NotNull

@Pattern(regexp="^[A-Z]{3}$") 
  public String getCurrency() {
    return currency;
  }

  public void setCurrency(String currency) {
    this.currency = currency;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CountResult countResult = (CountResult) o;
    return Objects.equals(this.count, countResult.count) &&
        Objects.equals(this.currency, countResult.currency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(count, currency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CountResult {\n");
    
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

