package dev.vality.swag.analytics.model;

import java.util.Objects;
import io.swagger.annotations.ApiModel;
import com.fasterxml.jackson.annotation.JsonValue;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

import com.fasterxml.jackson.annotation.JsonCreator;

/**
 * Статус чарджбэка
 */
public enum ChargebackStatus {
  
  PENDING("pending"),
  
  ACCEPTED("accepted"),
  
  REJECTED("rejected"),
  
  CANCELLED("cancelled");

  private String value;

  ChargebackStatus(String value) {
    this.value = value;
  }

  @Override
  @JsonValue
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static ChargebackStatus fromValue(String text) {
    for (ChargebackStatus b : ChargebackStatus.values()) {
      if (String.valueOf(b.value).equals(text)) {
        return b;
      }
    }
    return null;
  }
}

