package dev.vality.swag.analytics.model;

import java.util.Objects;
import io.swagger.annotations.ApiModel;
import com.fasterxml.jackson.annotation.JsonValue;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

import com.fasterxml.jackson.annotation.JsonCreator;

/**
 * Этап прохождения чарджбэка
 */
public enum ChargebackStage {
  
  CHARGEBACK("chargeback"),
  
  PRE_ARBITRATION("pre_arbitration"),
  
  ARBITRATION("arbitration");

  private String value;

  ChargebackStage(String value) {
    this.value = value;
  }

  @Override
  @JsonValue
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static ChargebackStage fromValue(String text) {
    for (ChargebackStage b : ChargebackStage.values()) {
      if (String.valueOf(b.value).equals(text)) {
        return b;
      }
    }
    return null;
  }
}

