package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import dev.vality.swag.analytics.model.ChargebackCategory;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Данные о причине чарджбэка
 */
@ApiModel(description = "Данные о причине чарджбэка")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class ChargebackReason   {
  @JsonProperty("code")
  private String code = null;

  @JsonProperty("category")
  private ChargebackCategory category = null;

  public ChargebackReason code(String code) {
    this.code = code;
    return this;
  }

  /**
   * Код категории
   * @return code
  **/
  @ApiModelProperty(value = "Код категории")


  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public ChargebackReason category(ChargebackCategory category) {
    this.category = category;
    return this;
  }

  /**
   * Get category
   * @return category
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull

  @Valid

  public ChargebackCategory getCategory() {
    return category;
  }

  public void setCategory(ChargebackCategory category) {
    this.category = category;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChargebackReason chargebackReason = (ChargebackReason) o;
    return Objects.equals(this.code, chargebackReason.code) &&
        Objects.equals(this.category, chargebackReason.category);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, category);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChargebackReason {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

