package dev.vality.swag.analytics.model;

import java.util.Objects;
import io.swagger.annotations.ApiModel;
import com.fasterxml.jackson.annotation.JsonValue;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

import com.fasterxml.jackson.annotation.JsonCreator;

/**
 * Категория чарджбэка
 */
public enum ChargebackCategory {
  
  FRAUD("fraud"),
  
  DISPUTE("dispute"),
  
  AUTHORISATION("authorisation"),
  
  PROCESSING_ERROR("processing_error");

  private String value;

  ChargebackCategory(String value) {
    this.value = value;
  }

  @Override
  @JsonValue
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static ChargebackCategory fromValue(String text) {
    for (ChargebackCategory b : ChargebackCategory.values()) {
      if (String.valueOf(b.value).equals(text)) {
        return b;
      }
    }
    return null;
  }
}

