package dev.vality.swag.analytics.model;

import java.util.Objects;
import io.swagger.annotations.ApiModel;
import com.fasterxml.jackson.annotation.JsonValue;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

import com.fasterxml.jackson.annotation.JsonCreator;

/**
 * Провайдер платежных токенов
 */
public enum BankCardTokenProvider {
  
  APPLEPAY("applepay"),
  
  GOOGLEPAY("googlepay"),
  
  SAMSUNGPAY("samsungpay"),
  
  YANDEXPAY("yandexpay");

  private String value;

  BankCardTokenProvider(String value) {
    this.value = value;
  }

  @Override
  @JsonValue
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static BankCardTokenProvider fromValue(String text) {
    for (BankCardTokenProvider b : BankCardTokenProvider.values()) {
      if (String.valueOf(b.value).equals(text)) {
        return b;
      }
    }
    return null;
  }
}

