package dev.vality.swag.analytics.model;

import java.util.Objects;
import io.swagger.annotations.ApiModel;
import com.fasterxml.jackson.annotation.JsonValue;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

import com.fasterxml.jackson.annotation.JsonCreator;

/**
 * Платежная система
 */
public enum BankCardPaymentSystem {
  
  VISA("visa"),
  
  MASTERCARD("mastercard"),
  
  VISAELECTRON("visaelectron"),
  
  MAESTRO("maestro"),
  
  FORBRUGSFORENINGEN("forbrugsforeningen"),
  
  DANKORT("dankort"),
  
  AMEX("amex"),
  
  DINERSCLUB("dinersclub"),
  
  DISCOVER("discover"),
  
  UNIONPAY("unionpay"),
  
  JCB("jcb"),
  
  NSPKMIR("nspkmir"),
  
  ELO("elo"),
  
  RUPAY("rupay"),
  
  DUMMY("dummy"),
  
  UZCARD("uzcard");

  private String value;

  BankCardPaymentSystem(String value) {
    this.value = value;
  }

  @Override
  @JsonValue
  public String toString() {
    return String.valueOf(value);
  }

  @JsonCreator
  public static BankCardPaymentSystem fromValue(String text) {
    for (BankCardPaymentSystem b : BankCardPaymentSystem.values()) {
      if (String.valueOf(b.value).equals(text)) {
        return b;
      }
    }
    return null;
  }
}

