package dev.vality.swag.analytics.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Данные расчётного счёта в банковской организации, ведущей деятельность под юрисдикцией РФ. 
 */
@ApiModel(description = "Данные расчётного счёта в банковской организации, ведущей деятельность под юрисдикцией РФ. ")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

public class BankAccount   {
  @JsonProperty("account")
  private String account = null;

  @JsonProperty("bankName")
  private String bankName = null;

  @JsonProperty("bankPostAccount")
  private String bankPostAccount = null;

  @JsonProperty("bankBik")
  private String bankBik = null;

  public BankAccount account(String account) {
    this.account = account;
    return this;
  }

  /**
   * Номер счёта
   * @return account
  **/
  @ApiModelProperty(required = true, value = "Номер счёта")
  @NotNull

@Pattern(regexp="^\\d{20}$") 
  public String getAccount() {
    return account;
  }

  public void setAccount(String account) {
    this.account = account;
  }

  public BankAccount bankName(String bankName) {
    this.bankName = bankName;
    return this;
  }

  /**
   * Наименование юридического лица банковской организации
   * @return bankName
  **/
  @ApiModelProperty(required = true, value = "Наименование юридического лица банковской организации")
  @NotNull

@Size(max=100) 
  public String getBankName() {
    return bankName;
  }

  public void setBankName(String bankName) {
    this.bankName = bankName;
  }

  public BankAccount bankPostAccount(String bankPostAccount) {
    this.bankPostAccount = bankPostAccount;
    return this;
  }

  /**
   * Get bankPostAccount
   * @return bankPostAccount
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull

@Pattern(regexp="^\\d{20}$") 
  public String getBankPostAccount() {
    return bankPostAccount;
  }

  public void setBankPostAccount(String bankPostAccount) {
    this.bankPostAccount = bankPostAccount;
  }

  public BankAccount bankBik(String bankBik) {
    this.bankBik = bankBik;
    return this;
  }

  /**
   * БИК банковской организации
   * @return bankBik
  **/
  @ApiModelProperty(required = true, value = "БИК банковской организации")
  @NotNull

@Pattern(regexp="^\\d{9}$") 
  public String getBankBik() {
    return bankBik;
  }

  public void setBankBik(String bankBik) {
    this.bankBik = bankBik;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BankAccount bankAccount = (BankAccount) o;
    return Objects.equals(this.account, bankAccount.account) &&
        Objects.equals(this.bankName, bankAccount.bankName) &&
        Objects.equals(this.bankPostAccount, bankAccount.bankPostAccount) &&
        Objects.equals(this.bankBik, bankAccount.bankBik);
  }

  @Override
  public int hashCode() {
    return Objects.hash(account, bankName, bankPostAccount, bankBik);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BankAccount {\n");
    
    sb.append("    account: ").append(toIndentedString(account)).append("\n");
    sb.append("    bankName: ").append(toIndentedString(bankName)).append("\n");
    sb.append("    bankPostAccount: ").append(toIndentedString(bankPostAccount)).append("\n");
    sb.append("    bankBik: ").append(toIndentedString(bankBik)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

