/**
 * NOTE: This class is auto generated by the swagger code generator program (2.3.1).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package dev.vality.swag.analytics.api;

import dev.vality.swag.analytics.model.DefaultLogicError;
import dev.vality.swag.analytics.model.GeneralError;
import dev.vality.swag.analytics.model.InlineResponse20013;
import dev.vality.swag.analytics.model.InlineResponse400;
import dev.vality.swag.analytics.model.InlineResponse4001;
import java.time.OffsetDateTime;
import dev.vality.swag.analytics.model.Report;
import dev.vality.swag.analytics.model.ReportLink;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.*;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

@Api(value = "reports", description = "the reports API")
public interface ReportsApi {

    Logger log = LoggerFactory.getLogger(ReportsApi.class);

    default Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value = "", nickname = "cancelReport", notes = "Отменить указанный отчет. Отчеты типа `provisionOfService` отменить нельзя", authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Reports", })
    @ApiResponses(value = { 
        @ApiResponse(code = 202, message = "Запрос на отмену отчета принят"),
        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации"),
        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(value = "/reports/{reportID}/cancel",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.POST)
    default ResponseEntity<Void> cancelReport(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@ApiParam(value = "Идентификатор отчета",required=true) @PathVariable("reportID") Long reportID,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ReportsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "", nickname = "createReport", notes = "Сгенерировать отчет с указанным типом по магазину за указанный промежуток времени", response = Report.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Reports", })
    @ApiResponses(value = { 
        @ApiResponse(code = 201, message = "Отчет создан", response = Report.class),
        @ApiResponse(code = 400, message = "Ошибочные данные для генерации", response = InlineResponse4001.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(value = "/reports",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.POST)
    default ResponseEntity<Report> createReport(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@NotNull @Size(min=1,max=40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) OffsetDateTime fromTime,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) OffsetDateTime toTime,@NotNull @ApiParam(value = "Тип отчета", required = true, allowableValues = "paymentRegistry") @Valid @RequestParam(value = "reportType", required = true) String reportType,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline,@Size(min=1,max=40) @ApiParam(value = "Идентификатор магазина") @Valid @RequestParam(value = "shopID", required = false) String shopID) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"reportType\" : \"provisionOfService\",  \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\",  \"fromTime\" : \"2000-01-23T04:56:07.000+00:00\",  \"files\" : [ {    \"filename\" : \"filename\",    \"id\" : \"id\",    \"signatures\" : {      \"sha256\" : \"sha256\",      \"md5\" : \"md5\"    }  }, {    \"filename\" : \"filename\",    \"id\" : \"id\",    \"signatures\" : {      \"sha256\" : \"sha256\",      \"md5\" : \"md5\"    }  } ],  \"id\" : 0,  \"shopID\" : \"shopID\",  \"partyID\" : \"partyID\",  \"toTime\" : \"2000-01-23T04:56:07.000+00:00\",  \"status\" : \"pending\"}", Report.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ReportsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "", nickname = "downloadFile", notes = "Скачать файл", response = ReportLink.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Reports", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Download link", response = ReportLink.class),
        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации"),
        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(value = "/reports/{reportID}/files/{fileID}/download",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.GET)
    default ResponseEntity<ReportLink> downloadFile(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@ApiParam(value = "Идентификатор отчета",required=true) @PathVariable("reportID") Long reportID,@Size(min=1,max=40) @ApiParam(value = "Идентификатор файла",required=true) @PathVariable("fileID") String fileID,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"url\" : \"url\"}", ReportLink.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ReportsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "", nickname = "getReport", notes = "Получить отчет по данному идентификатору", response = Report.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Reports", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Найденный отчет", response = Report.class),
        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации"),
        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(value = "/reports/{reportID}",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.GET)
    default ResponseEntity<Report> getReport(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@ApiParam(value = "Идентификатор отчета",required=true) @PathVariable("reportID") Long reportID,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"reportType\" : \"provisionOfService\",  \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\",  \"fromTime\" : \"2000-01-23T04:56:07.000+00:00\",  \"files\" : [ {    \"filename\" : \"filename\",    \"id\" : \"id\",    \"signatures\" : {      \"sha256\" : \"sha256\",      \"md5\" : \"md5\"    }  }, {    \"filename\" : \"filename\",    \"id\" : \"id\",    \"signatures\" : {      \"sha256\" : \"sha256\",      \"md5\" : \"md5\"    }  } ],  \"id\" : 0,  \"shopID\" : \"shopID\",  \"partyID\" : \"partyID\",  \"toTime\" : \"2000-01-23T04:56:07.000+00:00\",  \"status\" : \"pending\"}", Report.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ReportsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "", nickname = "searchReports", notes = "Получить список отчетов по данному магазину за период", response = InlineResponse20013.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Reports", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Найденные отчеты", response = InlineResponse20013.class),
        @ApiResponse(code = 400, message = "Ошибочные данные для получения", response = InlineResponse400.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации") })
    @RequestMapping(value = "/reports",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.GET)
    default ResponseEntity<InlineResponse20013> searchReports(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@NotNull @Size(min=1,max=40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) OffsetDateTime fromTime,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) OffsetDateTime toTime,@NotNull @ApiParam(value = "Типы отчетов", required = true, allowableValues = "provisionOfService, paymentRegistry, paymentRegistryByPayout") @Valid @RequestParam(value = "reportTypes", required = true) List<String> reportTypes,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline,@Size(min=1,max=40) @ApiParam(value = "Идентификатор магазина") @Valid @RequestParam(value = "shopID", required = false) String shopID,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm,@Min(1) @Max(1000) @ApiParam(value = "Лимит выборки") @Valid @RequestParam(value = "limit", required = false) Integer limit,@ApiParam(value = "Токен, сигнализирующий о том, что в ответе передана только часть данных. Для получения следующей части нужно повторно обратиться к сервису, указав тот же набор условий и полученый токен. Если токена нет, получена последняя часть данных. ") @Valid @RequestParam(value = "continuationToken", required = false) String continuationToken) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"result\" : [ {    \"reportType\" : \"provisionOfService\",    \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\",    \"fromTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"files\" : [ {      \"filename\" : \"filename\",      \"id\" : \"id\",      \"signatures\" : {        \"sha256\" : \"sha256\",        \"md5\" : \"md5\"      }    }, {      \"filename\" : \"filename\",      \"id\" : \"id\",      \"signatures\" : {        \"sha256\" : \"sha256\",        \"md5\" : \"md5\"      }    } ],    \"id\" : 0,    \"shopID\" : \"shopID\",    \"partyID\" : \"partyID\",    \"toTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"status\" : \"pending\"  }, {    \"reportType\" : \"provisionOfService\",    \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\",    \"fromTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"files\" : [ {      \"filename\" : \"filename\",      \"id\" : \"id\",      \"signatures\" : {        \"sha256\" : \"sha256\",        \"md5\" : \"md5\"      }    }, {      \"filename\" : \"filename\",      \"id\" : \"id\",      \"signatures\" : {        \"sha256\" : \"sha256\",        \"md5\" : \"md5\"      }    } ],    \"id\" : 0,    \"shopID\" : \"shopID\",    \"partyID\" : \"partyID\",    \"toTime\" : \"2000-01-23T04:56:07.000+00:00\",    \"status\" : \"pending\"  } ],  \"continuationToken\" : \"continuationToken\"}", InlineResponse20013.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ReportsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
