/**
 * NOTE: This class is auto generated by the swagger code generator program (2.3.1).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package dev.vality.swag.analytics.api;

import dev.vality.swag.analytics.model.DefaultLogicError;
import dev.vality.swag.analytics.model.GeneralError;
import dev.vality.swag.analytics.model.InlineResponse20011;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.*;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

@Api(value = "payouts", description = "the payouts API")
public interface PayoutsApi {

    Logger log = LoggerFactory.getLogger(PayoutsApi.class);

    default Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value = "", nickname = "searchPayouts", notes = "Поиск выплат", response = InlineResponse20011.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Search", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Найденные выплаты", response = InlineResponse20011.class),
        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации"),
        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(value = "/payouts",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.GET)
    default ResponseEntity<InlineResponse20011> searchPayouts(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@NotNull @Size(min=1,max=40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) OffsetDateTime fromTime,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) OffsetDateTime toTime,@NotNull @Min(1) @Max(1000) @ApiParam(value = "Лимит выборки", required = true) @Valid @RequestParam(value = "limit", required = true) Integer limit,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline,@Size(min=1,max=40) @ApiParam(value = "Идентификатор магазина") @Valid @RequestParam(value = "shopID", required = false) String shopID,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm,@Min(0)@ApiParam(value = "Смещение выборки") @Valid @RequestParam(value = "offset", required = false) Integer offset,@Size(min=1,max=40) @ApiParam(value = "Идентификатор выплаты") @Valid @RequestParam(value = "payoutID", required = false) String payoutID,@ApiParam(value = "Тип выплаты для поиска   * PayoutAccount - выплата на банковский счёт   * Wallet - выплата на кошелёк   * PaymentInstitutionAccount - выплата на счёт платежной организации ", allowableValues = "PayoutAccount, Wallet, PaymentInstitutionAccount") @Valid @RequestParam(value = "payoutToolType", required = false) String payoutToolType,@ApiParam(value = "Идентификаторы магазинов, исключаемых из поиска") @Valid @RequestParam(value = "excludedShops", required = false) List<String> excludedShops,@ApiParam(value = "Токен, сигнализирующий о том, что в ответе передана только часть данных. Для получения следующей части нужно повторно обратиться к сервису, указав тот же набор условий и полученый токен. Если токена нет, получена последняя часть данных. ") @Valid @RequestParam(value = "continuationToken", required = false) String continuationToken) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"result\" : [ {    \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\",    \"amount\" : 1,    \"payoutToolDetails\" : {      \"detailsType\" : \"detailsType\"    },    \"metadata\" : {      \"payoutDesc\" : \"Custom payout\"    },    \"cancellationDetails\" : \"cancellationDetails\",    \"fee\" : 0,    \"currency\" : \"currency\",    \"id\" : \"id\",    \"shopID\" : \"shopID\",    \"status\" : \"status\"  }, {    \"createdAt\" : \"2000-01-23T04:56:07.000+00:00\",    \"amount\" : 1,    \"payoutToolDetails\" : {      \"detailsType\" : \"detailsType\"    },    \"metadata\" : {      \"payoutDesc\" : \"Custom payout\"    },    \"cancellationDetails\" : \"cancellationDetails\",    \"fee\" : 0,    \"currency\" : \"currency\",    \"id\" : \"id\",    \"shopID\" : \"shopID\",    \"status\" : \"status\"  } ],  \"totalCount\" : 0,  \"continuationToken\" : \"continuationToken\"}", InlineResponse20011.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PayoutsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
