/**
 * NOTE: This class is auto generated by the swagger code generator program (2.3.1).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package dev.vality.swag.analytics.api;

import dev.vality.swag.analytics.model.DefaultLogicError;
import dev.vality.swag.analytics.model.GeneralError;
import dev.vality.swag.analytics.model.InlineResponse20010;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.*;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

@Api(value = "payments", description = "the payments API")
public interface PaymentsApi {

    Logger log = LoggerFactory.getLogger(PaymentsApi.class);

    default Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value = "", nickname = "searchPayments", notes = "Поиск платежей", response = InlineResponse20010.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Search", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Найденные платежи", response = InlineResponse20010.class),
        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации"),
        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(value = "/payments",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.GET)
    default ResponseEntity<InlineResponse20010> searchPayments(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@NotNull @Size(min=1,max=40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) OffsetDateTime fromTime,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) OffsetDateTime toTime,@NotNull @Min(1) @Max(1000) @ApiParam(value = "Лимит выборки", required = true) @Valid @RequestParam(value = "limit", required = true) Integer limit,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline,@Size(min=1,max=40) @ApiParam(value = "Идентификатор магазина") @Valid @RequestParam(value = "shopID", required = false) String shopID,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm,@ApiParam(value = "Список инвойсов") @Valid @RequestParam(value = "invoiceIDs", required = false) List<String> invoiceIDs,@ApiParam(value = "Статус платежа для поиска", allowableValues = "pending, processed, captured, cancelled, refunded, failed") @Valid @RequestParam(value = "paymentStatus", required = false) String paymentStatus,@ApiParam(value = "Flow платежа", allowableValues = "instant, hold") @Valid @RequestParam(value = "paymentFlow", required = false) String paymentFlow,@ApiParam(value = "Метод оплаты", allowableValues = "bankCard, paymentTerminal") @Valid @RequestParam(value = "paymentMethod", required = false) String paymentMethod,@ApiParam(value = "Провайдер платежного терминала", allowableValues = "euroset, wechat, alipay, zotapay, qps, uzcard, rbs") @Valid @RequestParam(value = "paymentTerminalProvider", required = false) String paymentTerminalProvider,@Size(min=1,max=40) @ApiParam(value = "Идентификатор инвойса") @Valid @RequestParam(value = "invoiceID", required = false) String invoiceID,@Size(min=1,max=40) @ApiParam(value = "Идентификатор платежа") @Valid @RequestParam(value = "paymentID", required = false) String paymentID,@Size(min=1,max=40) @ApiParam(value = "Внешний идентификатор") @Valid @RequestParam(value = "externalID", required = false) String externalID,@Size(max=100) @ApiParam(value = "Email, указанный при оплате") @Valid @RequestParam(value = "payerEmail", required = false) String payerEmail,@Size(max=45) @ApiParam(value = "IP-адрес плательщика") @Valid @RequestParam(value = "payerIP", required = false) String payerIP,@Size(max=1000) @ApiParam(value = "Уникальный отпечаток user agent'а плательщика") @Valid @RequestParam(value = "payerFingerprint", required = false) String payerFingerprint,@Size(min=1,max=40) @ApiParam(value = "Идентификатор плательщика") @Valid @RequestParam(value = "customerID", required = false) String customerID,@Pattern(regexp="^\\d{6}$") @ApiParam(value = "Первые 6 цифр номера карты") @Valid @RequestParam(value = "first6", required = false) String first6,@Pattern(regexp="^\\d{4}$") @ApiParam(value = "Последние 4 цифры номера карты") @Valid @RequestParam(value = "last4", required = false) String last4,@Pattern(regexp="^[a-zA-Z0-9]{12}$") @ApiParam(value = "Retrieval Reference Number") @Valid @RequestParam(value = "rrn", required = false) String rrn,@Size(min=1,max=40) @ApiParam(value = "Authorization Approval Code") @Valid @RequestParam(value = "approvalCode", required = false) String approvalCode,@ApiParam(value = "Провайдер платежных токенов", allowableValues = "applepay, googlepay, samsungpay, yandexpay") @Valid @RequestParam(value = "bankCardTokenProvider", required = false) String bankCardTokenProvider,@ApiParam(value = "Платежная система", allowableValues = "visa, mastercard, visaelectron, maestro, forbrugsforeningen, dankort, amex, dinersclub, discover, unionpay, jcb, nspkmir, elo, rupay, dummy, uzcard") @Valid @RequestParam(value = "bankCardPaymentSystem", required = false) String bankCardPaymentSystem,@Min(1)@ApiParam(value = "Минимальная сумма платежа") @Valid @RequestParam(value = "paymentAmountFrom", required = false) Long paymentAmountFrom,@Min(1)@ApiParam(value = "Максимальная сумма платежа") @Valid @RequestParam(value = "paymentAmountTo", required = false) Long paymentAmountTo,@ApiParam(value = "Идентификаторы магазинов, исключаемых из поиска") @Valid @RequestParam(value = "excludedShops", required = false) List<String> excludedShops,@ApiParam(value = "Токен, сигнализирующий о том, что в ответе передана только часть данных. Для получения следующей части нужно повторно обратиться к сервису, указав тот же набор условий и полученый токен. Если токена нет, получена последняя часть данных. ") @Valid @RequestParam(value = "continuationToken", required = false) String continuationToken) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ],  \"continuationToken\" : \"continuationToken\"}", InlineResponse20010.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PaymentsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
