/**
 * NOTE: This class is auto generated by the swagger code generator program (2.3.1).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package dev.vality.swag.analytics.api;

import dev.vality.swag.analytics.model.DefaultLogicError;
import dev.vality.swag.analytics.model.GeneralError;
import dev.vality.swag.analytics.model.InlineResponse200;
import dev.vality.swag.analytics.model.InlineResponse2001;
import dev.vality.swag.analytics.model.InlineResponse2002;
import dev.vality.swag.analytics.model.InlineResponse2003;
import dev.vality.swag.analytics.model.InlineResponse2004;
import dev.vality.swag.analytics.model.InlineResponse2005;
import dev.vality.swag.analytics.model.InlineResponse2006;
import dev.vality.swag.analytics.model.InlineResponse2007;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.*;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2022-03-18T10:44:56.284Z")

@Api(value = "analytics", description = "the analytics API")
public interface AnalyticsApi {

    Logger log = LoggerFactory.getLogger(AnalyticsApi.class);

    default Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value = "", nickname = "getAveragePayment", notes = "Получение среднего размера платежа с группировкой по валютам", response = InlineResponse2001.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Analytics", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Средний размер платежа с группировкой по валютам", response = InlineResponse2001.class),
        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации"),
        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(value = "/analytics/payments/average",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.GET)
    default ResponseEntity<InlineResponse2001> getAveragePayment(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@NotNull @Size(min=1,max=40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) OffsetDateTime fromTime,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) OffsetDateTime toTime,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs,@ApiParam(value = "Идентификаторы магазинов не включаемые в запрос") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ]}", InlineResponse2001.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "", nickname = "getCurrentBalances", notes = "Получение текущего баланса по магазину", response = InlineResponse2001.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Analytics", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Список оборотов с группировкой по валютам", response = InlineResponse2001.class),
        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации"),
        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(value = "/analytics/balances/current",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.GET)
    default ResponseEntity<InlineResponse2001> getCurrentBalances(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@NotNull @Size(min=1,max=40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs,@ApiParam(value = "Идентификаторы магазинов не включаемые в запрос") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ]}", InlineResponse2001.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "", nickname = "getCurrentBalancesGroupByShop", notes = "Получение текущего баланса с группировкой по магазинам", response = InlineResponse200.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Analytics", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Список балансов с группировкой по магазинам", response = InlineResponse200.class),
        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации"),
        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(value = "/analytics/balances/current-shop-balances",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.GET)
    default ResponseEntity<InlineResponse200> getCurrentBalancesGroupByShop(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@NotNull @Size(min=1,max=40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs,@ApiParam(value = "Идентификаторы магазинов не включаемые в запрос") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"result\" : [ {    \"groupBySHopResults\" : [ {      \"amountResults\" : [ \"\", \"\" ],      \"id\" : \"id\"    }, {      \"amountResults\" : [ \"\", \"\" ],      \"id\" : \"id\"    } ]  }, {    \"groupBySHopResults\" : [ {      \"amountResults\" : [ \"\", \"\" ],      \"id\" : \"id\"    }, {      \"amountResults\" : [ \"\", \"\" ],      \"id\" : \"id\"    } ]  } ]}", InlineResponse200.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "", nickname = "getPaymentsAmount", notes = "Получение списка оборотов с группировкой по валютам", response = InlineResponse2001.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Analytics", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Список оборотов с группировкой по валютам", response = InlineResponse2001.class),
        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации"),
        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(value = "/analytics/payments/amount",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.GET)
    default ResponseEntity<InlineResponse2001> getPaymentsAmount(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@NotNull @Size(min=1,max=40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) OffsetDateTime fromTime,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) OffsetDateTime toTime,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs,@ApiParam(value = "Идентификаторы магазинов не включаемые в запрос") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ]}", InlineResponse2001.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "", nickname = "getPaymentsCount", notes = "Получение количества платежей с группировкой по валютам", response = InlineResponse2003.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Analytics", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Среднее количество платежей с группировкой по валютам", response = InlineResponse2003.class),
        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации"),
        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(value = "/analytics/payments/count",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.GET)
    default ResponseEntity<InlineResponse2003> getPaymentsCount(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@NotNull @Size(min=1,max=40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) OffsetDateTime fromTime,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) OffsetDateTime toTime,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs,@ApiParam(value = "Идентификаторы магазинов не включаемые в запрос") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ]}", InlineResponse2003.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "", nickname = "getPaymentsErrorDistribution", notes = "Получение распределения ошибок", response = InlineResponse2004.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Analytics", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Распределение ошибок", response = InlineResponse2004.class),
        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации"),
        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(value = "/analytics/payments/errors",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.GET)
    default ResponseEntity<InlineResponse2004> getPaymentsErrorDistribution(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@NotNull @Size(min=1,max=40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) OffsetDateTime fromTime,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) OffsetDateTime toTime,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs,@ApiParam(value = "Идентификаторы магазинов не включаемые в запрос") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ]}", InlineResponse2004.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "", nickname = "getPaymentsSplitAmount", notes = "Получение списка оборотов с группировкой по валютам и разделенные по временным интервалам", response = InlineResponse2005.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Analytics", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Список оборотов с группировкой по валютам и разделенные по временным интервалам", response = InlineResponse2005.class),
        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации"),
        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(value = "/analytics/payments/split-amount",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.GET)
    default ResponseEntity<InlineResponse2005> getPaymentsSplitAmount(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@NotNull @Size(min=1,max=40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) OffsetDateTime fromTime,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) OffsetDateTime toTime,@NotNull @ApiParam(value = "Единица времени сегмента разбиения", required = true, allowableValues = "minute, hour, day, week, month, year") @Valid @RequestParam(value = "splitUnit", required = true) String splitUnit,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs,@ApiParam(value = "Идентификаторы магазинов не включаемые в запрос") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"result\" : [ {    \"splitUnit\" : \"minute\",    \"currency\" : \"currency\",    \"offsetAmounts\" : [ {      \"amount\" : 1,      \"offset\" : 0    }, {      \"amount\" : 1,      \"offset\" : 0    } ]  }, {    \"splitUnit\" : \"minute\",    \"currency\" : \"currency\",    \"offsetAmounts\" : [ {      \"amount\" : 1,      \"offset\" : 0    }, {      \"amount\" : 1,      \"offset\" : 0    } ]  } ]}", InlineResponse2005.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "", nickname = "getPaymentsSplitCount", notes = "Получение количества платежей с группировкой по валютам и статусам, разделенного по временным интервалам", response = InlineResponse2006.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Analytics", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Количество платежей с группировкой по валютам и статусам, разделенное по временным интервалам", response = InlineResponse2006.class),
        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации"),
        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(value = "/analytics/payments/split-count",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.GET)
    default ResponseEntity<InlineResponse2006> getPaymentsSplitCount(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@NotNull @Size(min=1,max=40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) OffsetDateTime fromTime,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) OffsetDateTime toTime,@NotNull @ApiParam(value = "Единица времени сегмента разбиения", required = true, allowableValues = "minute, hour, day, week, month, year") @Valid @RequestParam(value = "splitUnit", required = true) String splitUnit,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs,@ApiParam(value = "Идентификаторы магазинов не включаемые в запрос") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"result\" : [ {    \"splitUnit\" : \"minute\",    \"statusOffsetCounts\" : [ {      \"status\" : \"pending\",      \"offsetCount\" : [ \"\", \"\" ]    }, {      \"status\" : \"pending\",      \"offsetCount\" : [ \"\", \"\" ]    } ],    \"currency\" : \"currency\"  }, {    \"splitUnit\" : \"minute\",    \"statusOffsetCounts\" : [ {      \"status\" : \"pending\",      \"offsetCount\" : [ \"\", \"\" ]    }, {      \"status\" : \"pending\",      \"offsetCount\" : [ \"\", \"\" ]    } ],    \"currency\" : \"currency\"  } ]}", InlineResponse2006.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "", nickname = "getPaymentsSubErrorDistribution", notes = "Получение распределения ошибок с подошибками", response = InlineResponse2007.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Analytics", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Распределение ошибок с подошибками", response = InlineResponse2007.class),
        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации"),
        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(value = "/analytics/payments/sub-errors",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.GET)
    default ResponseEntity<InlineResponse2007> getPaymentsSubErrorDistribution(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@NotNull @Size(min=1,max=40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) OffsetDateTime fromTime,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) OffsetDateTime toTime,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs,@ApiParam(value = "Идентификаторы магазинов не включаемые в запрос") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ]}", InlineResponse2007.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "", nickname = "getPaymentsToolDistribution", notes = "Получение распределения использования платежных инструментов", response = InlineResponse2002.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Analytics", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Распределение использования платежных инструментов", response = InlineResponse2002.class),
        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации"),
        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(value = "/analytics/payments-tool",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.GET)
    default ResponseEntity<InlineResponse2002> getPaymentsToolDistribution(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@NotNull @Size(min=1,max=40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) OffsetDateTime fromTime,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) OffsetDateTime toTime,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs,@ApiParam(value = "Идентификаторы магазинов не включаемые в запрос") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ]}", InlineResponse2002.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "", nickname = "getRefundsAmount", notes = "Получение списка возвратов с группировкой по валютам", response = InlineResponse2001.class, authorizations = {
        @Authorization(value = "bearer")
    }, tags={ "Analytics", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "Список возвратов с группировкой по валютам", response = InlineResponse2001.class),
        @ApiResponse(code = 400, message = "Неверные данные", response = DefaultLogicError.class),
        @ApiResponse(code = 401, message = "Ошибка авторизации"),
        @ApiResponse(code = 404, message = "Заданный ресурс не найден", response = GeneralError.class) })
    @RequestMapping(value = "/analytics/refunds/amount",
        produces = { "application/json; charset=utf-8" }, 
        consumes = { "application/json; charset=utf-8" },
        method = RequestMethod.GET)
    default ResponseEntity<InlineResponse2001> getRefundsAmount(@ApiParam(value = "Уникальный идентификатор запроса к системе" ,required=true) @RequestHeader(value="X-Request-ID", required=true) String xRequestID,@NotNull @Size(min=1,max=40) @ApiParam(value = "Уникальный идентификатор участника в рамках платформы", required = true) @Valid @RequestParam(value = "partyID", required = true) String partyID,@NotNull @ApiParam(value = "Начало временного отрезка", required = true) @Valid @RequestParam(value = "fromTime", required = true) OffsetDateTime fromTime,@NotNull @ApiParam(value = "Конец временного отрезка", required = true) @Valid @RequestParam(value = "toTime", required = true) OffsetDateTime toTime,@ApiParam(value = "Максимальное время обработки запроса" ) @RequestHeader(value="X-Request-Deadline", required=false) String xRequestDeadline,@ApiParam(value = "Идентификаторы магазинов") @Valid @RequestParam(value = "shopIDs", required = false) List<String> shopIDs,@ApiParam(value = "Идентификаторы магазинов не включаемые в запрос") @Valid @RequestParam(value = "excludeShopIDs", required = false) List<String> excludeShopIDs,@ApiParam(value = "Тип магазина, тестовый или «боевой»", allowableValues = "live, test") @Valid @RequestParam(value = "paymentInstitutionRealm", required = false) String paymentInstitutionRealm) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
            if (getAcceptHeader().get().contains("application/json")) {
                try {
                    return new ResponseEntity<>(getObjectMapper().get().readValue("{  \"result\" : [ \"\", \"\" ]}", InlineResponse2001.class), HttpStatus.NOT_IMPLEMENTED);
                } catch (IOException e) {
                    log.error("Couldn't serialize response for content type application/json", e);
                    return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
                }
            }
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default AnalyticsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
