/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.kafka.common.serialization;

import dev.vality.kafka.common.exception.KafkaSerializationException;
import dev.vality.kafka.common.exception.TransportException;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThriftDeserializer<T extends TBase>
implements Deserializer<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractThriftDeserializer.class);
    protected final ThreadLocal<TDeserializer> thriftDeserializer = ThreadLocal.withInitial(this::createNewDeserializer);

    public void configure(Map<String, ?> configs, boolean isKey) {
        Map<String, ?> filtered = AbstractThriftDeserializer.filterSslProperties(configs);
        log.warn("AbstractThriftDeserializer configure configs: {} isKey: {} is do nothing!", filtered, (Object)isKey);
    }

    public static Map<String, ?> filterSslProperties(Map<String, ?> configs) {
        return configs.entrySet().stream().filter(entry -> !((String)entry.getKey()).contains("ssl")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void close() {
        this.thriftDeserializer.remove();
    }

    protected T deserialize(byte[] data, T t) {
        try {
            this.thriftDeserializer.get().deserialize(t, data);
        }
        catch (Exception e) {
            log.error("Error when deserialize data", (Throwable)e);
            throw new KafkaSerializationException(e);
        }
        return t;
    }

    private TDeserializer createNewDeserializer() {
        try {
            return new TDeserializer();
        }
        catch (TTransportException ex) {
            throw new TransportException(ex);
        }
    }
}

