/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.kafka.common.exception.handler;

import dev.vality.kafka.common.util.LogUtil;
import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.ExponentialBackOff;

public class ExponentialBackOffDefaultErrorHandler
extends DefaultErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(ExponentialBackOffDefaultErrorHandler.class);

    public ExponentialBackOffDefaultErrorHandler(ExponentialBackOff exponentialBackOff) {
        super((BackOff)exponentialBackOff);
    }

    public boolean isAckAfterHandle() {
        return false;
    }

    public void handleRemaining(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        log.error(String.format("Records commit failed, size=%d, %s", records.size(), LogUtil.toString(records)), (Throwable)thrownException);
        super.handleRemaining(thrownException, records, consumer, container);
    }

    public void handleBatch(Exception thrownException, ConsumerRecords<?, ?> data, Consumer<?, ?> consumer, MessageListenerContainer container, Runnable invokeListener) {
        log.error(String.format("Records commit failed, size=%d, %s", data.count(), LogUtil.toSummaryString(data)), (Throwable)thrownException);
        super.handleBatch(thrownException, data, consumer, container, invokeListener);
    }
}

