/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.kafka.common.serialization;

import dev.vality.kafka.common.exception.KafkaSerializationException;
import dev.vality.kafka.common.exception.TransportException;
import dev.vality.kafka.common.serialization.AbstractThriftDeserializer;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftSerializer<T extends TBase>
implements Serializer<T> {
    private static final Logger log = LoggerFactory.getLogger(ThriftSerializer.class);
    private final ThreadLocal<TSerializer> thriftSerializer = ThreadLocal.withInitial(this::createNewSeriaflizer);

    public void configure(Map<String, ?> configs, boolean isKey) {
        Map<String, ?> filtered = AbstractThriftDeserializer.filterSslProperties(configs);
        log.warn("ThriftSerializer configure configs: {} isKey: {} is do nothing!", filtered, (Object)isKey);
    }

    public byte[] serialize(String topic, T data) {
        log.debug("Serialize message, topic: {}, data: {}", (Object)topic, data);
        try {
            return this.thriftSerializer.get().serialize(data);
        }
        catch (TException e) {
            log.error("Error when serialize data: {} ", data, (Object)e);
            throw new KafkaSerializationException(e);
        }
    }

    public void close() {
        this.thriftSerializer.remove();
    }

    private TSerializer createNewSeriaflizer() {
        try {
            return new TSerializer();
        }
        catch (TTransportException ex) {
            throw new TransportException(ex);
        }
    }
}

