/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.kafka.common.retry;

import dev.vality.kafka.common.retry.SimpleRetryContext;
import java.util.Map;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryPolicy;
import org.springframework.util.ClassUtils;

public class ConfigurableRetryPolicy
implements RetryPolicy {
    private final int maxAttempts;
    private final BinaryExceptionClassifier retryableClassifier;

    public ConfigurableRetryPolicy(int maxAttempts, Map<Class<? extends Throwable>, Boolean> retryableExceptions) {
        this(maxAttempts, retryableExceptions, false, false);
    }

    public ConfigurableRetryPolicy(int maxAttempts, Map<Class<? extends Throwable>, Boolean> retryableExceptions, boolean traverseCauses, boolean defaultValue) {
        this.maxAttempts = maxAttempts;
        this.retryableClassifier = new BinaryExceptionClassifier(retryableExceptions, defaultValue);
        this.retryableClassifier.setTraverseCauses(traverseCauses);
    }

    public BinaryExceptionClassifier getRetryableClassifier() {
        return this.retryableClassifier;
    }

    public boolean canRetry(RetryContext context) {
        Throwable t = context.getLastThrowable();
        return !(t != null && !this.retryForException(t) || this.maxAttempts >= 0 && context.getRetryCount() >= this.maxAttempts);
    }

    public RetryContext open(RetryContext parent) {
        return new SimpleRetryContext(parent);
    }

    public void close(RetryContext context) {
    }

    public void registerThrowable(RetryContext context, Throwable throwable) {
        ((SimpleRetryContext)context).registerThrowable(throwable);
    }

    private boolean retryForException(Throwable ex) {
        return this.retryableClassifier.classify(ex);
    }

    public String toString() {
        return ClassUtils.getShortName(this.getClass()) + "[maxAttempts=" + this.maxAttempts + "]";
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }
}

