/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.kafka.common.exception.handler;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.SeekToCurrentErrorHandler;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.FixedBackOff;

public class SeekToCurrentWithSleepErrorHandler
extends SeekToCurrentErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(SeekToCurrentWithSleepErrorHandler.class);
    private final Integer sleepTimeSeconds;

    public SeekToCurrentWithSleepErrorHandler() {
        super.setAckAfterHandle(false);
        this.sleepTimeSeconds = 5;
    }

    public SeekToCurrentWithSleepErrorHandler(int sleepTimeSeconds, int maxFailures) {
        super((BackOff)new FixedBackOff(0L, maxFailures == -1 ? Long.MAX_VALUE : (long)maxFailures - 1L));
        super.setAckAfterHandle(false);
        this.sleepTimeSeconds = sleepTimeSeconds;
    }

    public void handle(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        log.error("Records commit failed", (Throwable)thrownException);
        this.sleepBeforeRetry();
        super.handle(thrownException, records, consumer, container);
    }

    private void sleepBeforeRetry() {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(this.sleepTimeSeconds.intValue()));
        }
        catch (InterruptedException var2) {
            Thread.currentThread().interrupt();
        }
    }
}

